/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.containers;

import com.exasol.containers.ExasolDockerImageReference;
import java.util.Objects;

class VersionBasedExasolDockerImageReference
implements ExasolDockerImageReference {
    private static final int DEFAULT_DOCKER_IMAGE_REVISION = 1;
    public static final int VERSION_NOT_PRESENT = -1;
    public static final String PREFIX_NOT_PRESENT = null;
    public static final String SUFFIX_NOT_PRESENT = null;
    private final String dockerImageId;
    private final int major;
    private final int minor;
    private final int fix;
    private final int dockerImageRevision;
    private final String prefix;
    private final String suffix;
    private final String suffixSeparator;

    @Deprecated(forRemoval=true)
    public VersionBasedExasolDockerImageReference(int major, int minor, int fix, String prefix, String suffixSeparator, String suffix, int dockerImageRevision) {
        this(VersionBasedExasolDockerImageReference.builder().major(major).minor(minor).fix(fix).prefix(prefix).suffixSeparator(suffixSeparator).suffix(suffix).dockerImageRevision(dockerImageRevision));
    }

    public static Builder builder() {
        return new Builder();
    }

    private VersionBasedExasolDockerImageReference(Builder builder) {
        this.dockerImageId = Objects.requireNonNull(builder.dockerImageId, "dockerImageId");
        this.major = builder.major;
        this.minor = builder.minor;
        this.fix = builder.fix;
        this.prefix = builder.prefix;
        this.suffixSeparator = builder.suffixSeparator;
        this.suffix = builder.suffix;
        this.dockerImageRevision = builder.dockerImageRevision == -1 && !this.isExasolSevenOrLater() ? 1 : builder.dockerImageRevision;
    }

    @Override
    public int getMajor() {
        return this.major;
    }

    @Override
    public boolean hasMajor() {
        return this.major != -1;
    }

    @Override
    public int getMinor() {
        return this.minor;
    }

    @Override
    public boolean hasMinor() {
        return this.minor != -1;
    }

    @Override
    public int getFixVersion() {
        return this.fix;
    }

    @Override
    public boolean hasFix() {
        return this.fix != -1;
    }

    @Override
    public int getDockerImageRevision() {
        return this.dockerImageRevision;
    }

    @Override
    public boolean hasDockerImageRevision() {
        return this.dockerImageRevision != -1;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public boolean hasPrefix() {
        return this.prefix != null;
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public boolean hasSuffix() {
        return this.suffix != null;
    }

    @Override
    public String toString() {
        return this.dockerImageId + ":" + this.constructPrefixPart() + this.constructVersionPart() + this.constructOptionalSuffixPart() + this.constructOptionalDockerImageRevisionPart();
    }

    private String constructPrefixPart() {
        return this.hasPrefix() ? this.prefix + "-" : "";
    }

    private String constructVersionPart() {
        return this.major + "." + this.minor + "." + this.fix;
    }

    private String constructOptionalSuffixPart() {
        return this.hasSuffix() ? this.suffixSeparator + this.suffix : "";
    }

    private String constructOptionalDockerImageRevisionPart() {
        if (this.isExasolSevenOrLater()) {
            return this.hasDockerImageRevision() ? "-d" + this.dockerImageRevision : "";
        }
        return "-d" + (this.hasDockerImageRevision() ? this.dockerImageRevision : 1);
    }

    private boolean isExasolSevenOrLater() {
        return this.major >= 7;
    }

    public static class Builder {
        private String dockerImageId = "exasol/docker-db";
        private int major;
        private int minor;
        private int fix;
        private int dockerImageRevision;
        private String prefix;
        private String suffix;
        private String suffixSeparator;

        private Builder() {
        }

        public Builder dockerImageId(String dockerImageId) {
            this.dockerImageId = dockerImageId;
            return this;
        }

        public Builder major(int major) {
            this.major = major;
            return this;
        }

        public Builder minor(int minor) {
            this.minor = minor;
            return this;
        }

        public Builder fix(int fix) {
            this.fix = fix;
            return this;
        }

        public Builder dockerImageRevision(int dockerImageRevision) {
            this.dockerImageRevision = dockerImageRevision;
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public Builder suffixSeparator(String suffixSeparator) {
            this.suffixSeparator = suffixSeparator;
            return this;
        }

        public VersionBasedExasolDockerImageReference build() {
            return new VersionBasedExasolDockerImageReference(this);
        }
    }
}

