/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.containers;

import com.exasol.containers.ExasolDockerImageReference;
import com.exasol.containers.LiteralExasolDockerImageReference;
import com.exasol.containers.VersionBasedExasolDockerImageReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DockerImageReferenceFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerImageReferenceFactory.class);
    private static final String REPOSITORY_PATTERN = "(?:(?:exasol/)?docker-db:)?";
    private static final String CUSTOM_IMAGE_PATTERN = "(?:([\\w./-]+):)";
    private static final String VERSION_PREFIX_PATTERN = "(?:(\\w+)-)?";
    private static final String EXASOL_VERSION_PATTERN = "(\\d+)(?:\\.(\\d+))?(?:\\.(\\d+))?";
    private static final String SUFFIX_PATTERN = "(?:([-.])([a-zA-Z]\\w*))??";
    private static final String DOCKER_IMAGE_REVISION_PATTERN = "(?:-d(\\d+))?";
    private static final Pattern OFFICIAL_DOCKER_IMAGE_VERSION_PATTERN = Pattern.compile("(?:(?:exasol/)?docker-db:)?(?:(\\w+)-)?(\\d+)(?:\\.(\\d+))?(?:\\.(\\d+))?(?:([-.])([a-zA-Z]\\w*))??(?:-d(\\d+))?");
    private static final Pattern CUSTOM_DOCKER_IMAGE_VERSION_PATTERN = Pattern.compile("(?:([\\w./-]+):)(\\d+)(?:\\.(\\d+))?(?:\\.(\\d+))?(?:([-.])([a-zA-Z]\\w*))??");

    private DockerImageReferenceFactory() {
    }

    static ExasolDockerImageReference parseOverridable(String imageName, boolean allowOverride) {
        return DockerImageReferenceFactory.parse(allowOverride ? DockerImageReferenceFactory.versionFromSystemPropertyOrIndividual(imageName) : imageName);
    }

    public static String versionFromSystemPropertyOrIndividual(String individual) {
        String fromProperty = System.getProperty("com.exasol.dockerdb.image");
        if (fromProperty != null) {
            return fromProperty;
        }
        LOGGER.info("System property '{}' is not set. Using docker image version '{}'.", (Object)"com.exasol.dockerdb.image", (Object)individual);
        return individual;
    }

    public static ExasolDockerImageReference parse(String reference) {
        Matcher matcher = OFFICIAL_DOCKER_IMAGE_VERSION_PATTERN.matcher(reference);
        if (matcher.matches()) {
            return DockerImageReferenceFactory.buildOfficialImage(matcher);
        }
        Matcher customImageMatcher = CUSTOM_DOCKER_IMAGE_VERSION_PATTERN.matcher(reference);
        if (customImageMatcher.matches()) {
            return DockerImageReferenceFactory.buildCustomImage(customImageMatcher);
        }
        return new LiteralExasolDockerImageReference(reference);
    }

    private static ExasolDockerImageReference buildOfficialImage(Matcher matcher) {
        return VersionBasedExasolDockerImageReference.builder().major(Integer.parseInt(matcher.group(2))).minor(matcher.group(3) == null ? 0 : Integer.parseInt(matcher.group(3))).fix(matcher.group(4) == null ? 0 : Integer.parseInt(matcher.group(4))).prefix(matcher.group(1) == null ? VersionBasedExasolDockerImageReference.PREFIX_NOT_PRESENT : matcher.group(1)).suffixSeparator(matcher.group(5) == null ? VersionBasedExasolDockerImageReference.SUFFIX_NOT_PRESENT : matcher.group(5)).suffix(matcher.group(6) == null ? VersionBasedExasolDockerImageReference.SUFFIX_NOT_PRESENT : matcher.group(6)).dockerImageRevision(matcher.group(7) == null ? -1 : Integer.parseInt(matcher.group(7))).build();
    }

    private static ExasolDockerImageReference buildCustomImage(Matcher matcher) {
        return VersionBasedExasolDockerImageReference.builder().dockerImageId(matcher.group(1)).major(Integer.parseInt(matcher.group(2))).minor(matcher.group(3) == null ? 0 : Integer.parseInt(matcher.group(3))).fix(matcher.group(4) == null ? 0 : Integer.parseInt(matcher.group(4))).prefix(null).suffixSeparator(matcher.group(5) == null ? VersionBasedExasolDockerImageReference.SUFFIX_NOT_PRESENT : matcher.group(5)).suffix(matcher.group(6) == null ? VersionBasedExasolDockerImageReference.SUFFIX_NOT_PRESENT : matcher.group(6)).dockerImageRevision(-1).build();
    }
}

