/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.containers;

import com.exasol.errorreporting.ExaError;
import java.util.regex.Pattern;
import org.testcontainers.containers.ContainerLaunchException;

public class DBVersionChecker {
    private static final int MAJOR_DEPRECATED_VERSION = 6;
    private static final int MINOR_DEPRECATED_VERSION = 2;

    private DBVersionChecker() {
    }

    public static void minimumSupportedDbVersionCheck(String dbVersion) {
        int minorVersion;
        int majorVersion;
        String[] dbVersionSplit = dbVersion.split(Pattern.quote("."));
        if (dbVersionSplit.length != 3) {
            throw new ContainerLaunchException(ExaError.messageBuilder((String)"E-ETC-14").message("Failed to parse database version. Version tag is invalid.", new Object[0]).ticketMitigation().toString());
        }
        try {
            majorVersion = Integer.parseInt(dbVersionSplit[0]);
            minorVersion = Integer.parseInt(dbVersionSplit[1]);
        }
        catch (Exception e) {
            throw new ContainerLaunchException(ExaError.messageBuilder((String)"E-ETC-15").message("Failed to parse database version. Version tag is invalid.", new Object[0]).ticketMitigation().toString());
        }
        if (majorVersion == 6 && minorVersion <= 2 || majorVersion < 6) {
            DBVersionChecker.throwDBVersionNotSupportedException();
        }
    }

    private static void throwDBVersionNotSupportedException() {
        throw new ContainerLaunchException(ExaError.messageBuilder((String)"E-ETC-13").message("Exasol Database version 6.2 and lower are no longer supported in this version of Exasol Testcontainers.", new Object[0]).toString());
    }
}

