/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.clusterlogs;

import com.exasol.bucketfs.monitor.BucketFsMonitor;
import com.exasol.bucketfs.monitor.TimestampState;
import com.exasol.clusterlogs.LogEntryPatternVerifier;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.time.LocalDateTime;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TimestampLogEntryPatternVerifier
implements LogEntryPatternVerifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimestampLogEntryPatternVerifier.class);
    private static final Pattern LOG_ENTRY_PATTERN = Pattern.compile("\\[. (\\d\\d)(\\d\\d)(\\d\\d) (\\d\\d:\\d\\d:\\d\\d).*");
    private final BucketFsMonitor.State state;
    private final TimeZone timeZone;

    TimestampLogEntryPatternVerifier(BucketFsMonitor.State state, TimeZone timeZone) {
        this.state = state;
        this.timeZone = timeZone;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isLogMessageFound(String stdout) {
        try (BufferedReader reader = new BufferedReader(new StringReader(stdout));){
            String line;
            while ((line = reader.readLine()) != null) {
                Matcher matcher;
                if (line.isBlank() || !(matcher = LOG_ENTRY_PATTERN.matcher(line)).matches()) continue;
                String isoTimestamp = "20" + matcher.group(1) + "-" + matcher.group(2) + "-" + matcher.group(3) + "T" + matcher.group(4);
                TimestampState logEntryState = TimestampState.of(LocalDateTime.parse(isoTimestamp), this.timeZone);
                if (this.state.accepts((BucketFsMonitor.State)logEntryState)) {
                    LOGGER.debug("Found matching log entry with {} (after {}): {}", new Object[]{logEntryState, this.state, line});
                    boolean bl = true;
                    return bl;
                }
                LOGGER.debug("Ignoring log entry with {} (after {}): {}", new Object[]{logEntryState, this.state, line});
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Error reading string", exception);
        }
    }

    public String toString() {
        return "TimestampLogEntryPatternVerifier [afterUtc=" + this.state.toString() + ", timeZone=" + this.timeZone.getID() + "]";
    }
}

