/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.bucketfs.monitor;

import com.exasol.bucketfs.monitor.BucketFsMonitor;
import com.exasol.bucketfs.monitor.LineCountState;
import com.exasol.containers.ExasolContainer;
import com.exasol.containers.ssh.SshException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;

public class LineCountRetriever
implements BucketFsMonitor.StateRetriever {
    private static final Logger LOGGER = LoggerFactory.getLogger(LineCountRetriever.class);
    private static final Pattern LINE_COUNT = Pattern.compile(" *(\\d+) .*");
    private final ExasolContainer<? extends Container<?>> container;
    private final String logPath;
    private final String logNamePattern;

    public LineCountRetriever(ExasolContainer<? extends Container<?>> container, String logPath, String logNamePattern) {
        this.container = container;
        this.logPath = logPath;
        this.logNamePattern = logNamePattern;
    }

    public BucketFsMonitor.State getState() {
        return new LineCountState(this.countLines());
    }

    private long countLines() {
        try {
            Container.ExecResult result = this.container.execInContainer(new String[]{"find", this.logPath, "-name", this.logNamePattern, "-exec", "wc", "-l", "{}", "+"});
            return this.parseWcOutput(result.getStdout());
        }
        catch (SshException | IOException | IllegalStateException | InterruptedException | NumberFormatException | UnsupportedOperationException exception) {
            LOGGER.warn("Could not retrieve length of log file {} in folder {}: {}", new Object[]{this.logNamePattern, this.logPath, exception.getMessage()});
            if (exception instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            return 0L;
        }
    }

    private long parseWcOutput(String stdout) throws IOException {
        long result = 0L;
        try (BufferedReader reader = new BufferedReader(new StringReader(stdout));){
            String line;
            while ((line = reader.readLine()) != null) {
                result = this.processLine(result, line);
            }
        }
        return result;
    }

    private long processLine(long soFar, String line) {
        if (line.isBlank()) {
            return soFar;
        }
        Matcher matcher = LINE_COUNT.matcher(line);
        if (!matcher.matches()) {
            return soFar;
        }
        if (this.isValid(soFar)) {
            throw new IllegalStateException(MessageFormat.format("Found multiple files in folder {0} matching pattern {1}", this.logPath, this.logNamePattern));
        }
        return Long.parseLong(matcher.group(1));
    }

    private boolean isValid(long result) {
        return result > 0L;
    }
}

