/*
 * Decompiled with CFR 0.152.
 */
package com.evanlennick.retry4j.backoff;

import com.evanlennick.retry4j.backoff.BackoffStrategy;
import java.time.Duration;

public class ExponentialBackoffStrategy
implements BackoffStrategy {
    @Override
    public long getMillisToWait(int numberOfTriesFailed, Duration delayBetweenAttempts) {
        double exponentialMultiplier = Math.pow(2.0, numberOfTriesFailed - 1);
        double result = exponentialMultiplier * (double)delayBetweenAttempts.toMillis();
        return (long)Math.min(result, 9.223372036854776E18);
    }
}

