/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.zone.ZoneRules;
import java.time.zone.ZoneRulesProvider;
import java.util.Collections;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;

public class FastUTCZoneId {
    private static final String customZoneId = "ITU-UTC";
    private static final ZoneId delegate;

    public static ZoneId get() {
        return delegate;
    }

    static {
        ZoneRulesProvider customProvider = new ZoneRulesProvider(){

            @Override
            protected Set<String> provideZoneIds() {
                return Collections.singleton(FastUTCZoneId.customZoneId);
            }

            @Override
            protected NavigableMap<String, ZoneRules> provideVersions(String zoneId) {
                return new TreeMap<String, ZoneRules>(){
                    {
                        this.put(FastUTCZoneId.customZoneId, ZoneOffset.UTC.getRules());
                    }
                };
            }

            @Override
            protected ZoneRules provideRules(String zoneId, boolean forCaching) {
                return ZoneOffset.UTC.getRules();
            }
        };
        ZoneRulesProvider.registerProvider(customProvider);
        delegate = ZoneId.of(customZoneId);
    }
}

