/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time;

import com.ethlo.time.EthloITU;
import com.ethlo.time.Field;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.Temporal;
import java.util.Date;

public class ITU {
    private static final EthloITU delegate = new EthloITU();
    private static final ZoneId GMT_ZONE = ZoneOffset.UTC;

    private ITU() {
    }

    public static OffsetDateTime parseDateTime(String s) {
        return delegate.parseDateTime(s);
    }

    public static String formatUtc(OffsetDateTime date, int fractionDigits) {
        return delegate.formatUtc(date, fractionDigits);
    }

    public static String formatUtc(OffsetDateTime date, Field lastIncluded, int fractionDigits) {
        return delegate.formatUtc(date, lastIncluded, fractionDigits);
    }

    public static String formatUtc(Date date) {
        return delegate.formatUtc(date);
    }

    public static String format(Date date, String timezone) {
        return delegate.format(date, timezone);
    }

    public static boolean isValid(String dateTime) {
        return delegate.isValid(dateTime);
    }

    public static String formatUtcMilli(OffsetDateTime date) {
        return delegate.formatUtcMilli(date);
    }

    public static String formatUtcMicro(OffsetDateTime date) {
        return delegate.formatUtcMicro(date);
    }

    public static String formatUtcNano(OffsetDateTime date) {
        return delegate.formatUtcNano(date);
    }

    public static String formatUtc(OffsetDateTime date) {
        return delegate.formatUtc(date);
    }

    public static String formatUtcMilli(Date date) {
        return delegate.formatUtcMilli(date);
    }

    public static String format(Date date, String timezone, int fractionDigits) {
        return delegate.format(date, timezone, fractionDigits);
    }

    public static Temporal parseLenient(String s) {
        return delegate.parseLenient(s);
    }

    public static <T extends Temporal> T parseLenient(String s, Class<T> type) {
        return delegate.parseLenient(s, type);
    }

    public static long toEpochMillis(Temporal temporal) {
        if (temporal instanceof Instant) {
            return ((Instant)temporal).toEpochMilli();
        }
        if (temporal instanceof OffsetDateTime) {
            return ITU.toEpochMillis(((OffsetDateTime)temporal).toInstant());
        }
        if (temporal instanceof LocalDate) {
            return ITU.toEpochMillis(((LocalDate)temporal).atStartOfDay(GMT_ZONE).toInstant());
        }
        if (temporal instanceof YearMonth) {
            return ITU.toEpochMillis(((YearMonth)temporal).atDay(1));
        }
        if (temporal instanceof Year) {
            return ITU.toEpochMillis(((Year)temporal).atDay(1));
        }
        throw new IllegalArgumentException("Unhandled type " + temporal.getClass());
    }
}

