/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time;

import com.ethlo.time.AbstractRfc3339;
import com.ethlo.time.Field;
import com.ethlo.time.LimitedCharArrayIntegerUtil;
import com.ethlo.time.StdJdkInternetDateTimeUtil;
import com.ethlo.time.W3cDateTimeUtil;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.Date;

public class FastInternetDateTimeUtil
extends AbstractRfc3339
implements W3cDateTimeUtil {
    private final StdJdkInternetDateTimeUtil delegate = new StdJdkInternetDateTimeUtil();
    private static final char PLUS = '+';
    private static final char MINUS = '-';
    private static final char DATE_SEPARATOR = '-';
    private static final char TIME_SEPARATOR = ':';
    private static final char SEPARATOR_UPPER = 'T';
    private static final char SEPARATOR_LOWER = 't';
    private static final char SEPARATOR_SPACE = ' ';
    private static final char FRACTION_SEPARATOR = '.';
    private static final char ZULU_UPPER = 'Z';
    private static final char ZULU_LOWER = 'z';
    private static final int[] widths = new int[]{100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10, 1};

    @Override
    public OffsetDateTime parseDateTime(String s) {
        Temporal t = this.doParseLenient(s, OffsetDateTime.class);
        if (t == null) {
            return null;
        }
        if (t instanceof OffsetDateTime) {
            return (OffsetDateTime)OffsetDateTime.class.cast(t);
        }
        throw new DateTimeException("Invalid RFC-3339 date-time: " + s);
    }

    private void assertPositionContains(char[] chars, int offset, char ... expected) {
        if (offset >= chars.length) {
            throw new DateTimeException("Abrupt end of input: " + new String(chars));
        }
        boolean found = false;
        for (char e : expected) {
            if (chars[offset] != e) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new DateTimeException("Expected character " + Arrays.toString(expected) + " at position " + (offset + 1) + " '" + new String(chars) + "'");
        }
    }

    private ZoneOffset parseTz(char[] chars, int offset) {
        int left = chars.length - offset;
        if (chars[offset] == 'Z' || chars[offset] == 'z') {
            this.assertNoMoreChars(chars, offset);
            return ZoneOffset.UTC;
        }
        if (left != 6) {
            throw new DateTimeException("Invalid timezone offset: " + new String(chars, offset, left));
        }
        char sign = chars[offset];
        int hours = LimitedCharArrayIntegerUtil.parsePositiveInt(chars, offset + 1, offset + 3);
        int minutes = LimitedCharArrayIntegerUtil.parsePositiveInt(chars, offset + 4, offset + 4 + 2);
        if (sign == '-') {
            hours = -hours;
        } else if (sign != '+') {
            throw new DateTimeException("Invalid character starting at position " + offset + 1);
        }
        if (sign == '-' && hours == 0 && minutes == 0) {
            throw new DateTimeException("Unknown 'Local Offset Convention' date-time not allowed");
        }
        return ZoneOffset.ofHoursMinutes(hours, minutes);
    }

    private void assertNoMoreChars(char[] chars, int lastUsed) {
        if (chars.length > lastUsed + 1) {
            throw new DateTimeException("Unparsed data from offset " + lastUsed + 1);
        }
    }

    @Override
    public String formatUtc(OffsetDateTime date, int fractionDigits) {
        return this.formatUtc(date, Field.SECOND, fractionDigits);
    }

    @Override
    public String formatUtc(OffsetDateTime date, Field lastIncluded, int fractionDigits) {
        boolean hasFractionDigits;
        this.assertMaxFractionDigits(fractionDigits);
        LocalDateTime utc = LocalDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC);
        char[] buf = new char[31];
        LimitedCharArrayIntegerUtil.toString(utc.getYear(), buf, 0, 4);
        if (lastIncluded == Field.YEAR) {
            return this.finish(buf, 4);
        }
        buf[4] = 45;
        LimitedCharArrayIntegerUtil.toString(utc.getMonthValue(), buf, 5, 2);
        if (lastIncluded == Field.MONTH) {
            return this.finish(buf, 7);
        }
        buf[7] = 45;
        LimitedCharArrayIntegerUtil.toString(utc.getDayOfMonth(), buf, 8, 2);
        if (lastIncluded == Field.DAY) {
            return this.finish(buf, 10);
        }
        buf[10] = 84;
        LimitedCharArrayIntegerUtil.toString(utc.getHour(), buf, 11, 2);
        buf[13] = 58;
        LimitedCharArrayIntegerUtil.toString(utc.getMinute(), buf, 14, 2);
        if (lastIncluded == Field.MINUTE) {
            return this.finish(buf, 16);
        }
        buf[16] = 58;
        LimitedCharArrayIntegerUtil.toString(utc.getSecond(), buf, 17, 2);
        boolean bl = hasFractionDigits = fractionDigits > 0;
        if (hasFractionDigits) {
            buf[19] = 46;
            this.addFractions(buf, fractionDigits, utc.getNano());
        }
        buf[hasFractionDigits ? 20 + fractionDigits : 19] = 90;
        int length = hasFractionDigits ? 21 + fractionDigits : 20;
        return this.finish(buf, length);
    }

    private String finish(char[] buf, int length) {
        return new String(buf, 0, length);
    }

    private void addFractions(char[] buf, int fractionDigits, int nano) {
        double d = widths[fractionDigits - 1];
        LimitedCharArrayIntegerUtil.toString((int)((double)nano / d), buf, 20, fractionDigits);
    }

    @Override
    public String formatUtc(Date date) {
        return this.formatUtc(OffsetDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC), 3);
    }

    @Override
    public String format(Date date, String timezone) {
        return this.delegate.format(date, timezone);
    }

    @Override
    public boolean isValid(String dateTime) {
        try {
            this.parseDateTime(dateTime);
            return true;
        }
        catch (DateTimeException exc) {
            return false;
        }
    }

    @Override
    public String formatUtcMilli(OffsetDateTime date) {
        return this.formatUtc(date, 3);
    }

    @Override
    public String formatUtcMicro(OffsetDateTime date) {
        return this.formatUtc(date, 6);
    }

    @Override
    public String formatUtcNano(OffsetDateTime date) {
        return this.formatUtc(date, 9);
    }

    @Override
    public String formatUtc(OffsetDateTime date) {
        return this.formatUtc(date, 0);
    }

    @Override
    public String formatUtcMilli(Date date) {
        return this.formatUtcMilli(OffsetDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC));
    }

    @Override
    public String format(Date date, String timezone, int fractionDigits) {
        return this.delegate.format(date, timezone, fractionDigits);
    }

    @Override
    public Temporal parseLenient(String s) {
        return this.doParseLenient(s, null);
    }

    @Override
    public <T extends Temporal> T parseLenient(String s, Class<T> type) {
        return (T)((Temporal)type.cast(this.doParseLenient(s, type)));
    }

    public <T extends Temporal> Temporal doParseLenient(String s, Class<T> type) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        Field maxRequired = type == null ? null : Field.valueOf(type);
        char[] chars = s.toCharArray();
        int year = LimitedCharArrayIntegerUtil.parsePositiveInt(chars, 0, 4);
        if (maxRequired == Field.YEAR || chars.length == 4) {
            return Year.of(year);
        }
        this.assertPositionContains(chars, 4, '-');
        int month = LimitedCharArrayIntegerUtil.parsePositiveInt(chars, 5, 7);
        if (maxRequired == Field.MONTH || chars.length == 7) {
            return YearMonth.of(year, month);
        }
        this.assertPositionContains(chars, 7, '-');
        int day = LimitedCharArrayIntegerUtil.parsePositiveInt(chars, 8, 10);
        if (maxRequired == Field.DAY || chars.length == 10) {
            return LocalDate.of(year, month, day);
        }
        this.assertPositionContains(chars, 10, 'T', 't', ' ');
        int hour = LimitedCharArrayIntegerUtil.parsePositiveInt(chars, 11, 13);
        this.assertPositionContains(chars, 13, ':');
        int minute = LimitedCharArrayIntegerUtil.parsePositiveInt(chars, 14, 16);
        if (maxRequired == Field.MINUTE || chars.length == 16) {
            return LocalDate.of(year, month, day);
        }
        switch (chars[16]) {
            case ':': {
                return this.seconds(year, month, day, hour, minute, chars);
            }
            case '+': 
            case '-': 
            case 'Z': 
            case 'z': {
                ZoneOffset zoneOffset = this.parseTz(chars, 16);
                return OffsetDateTime.of(year, month, day, hour, minute, 0, 0, zoneOffset);
            }
        }
        this.assertPositionContains(chars, 16, ':', '+', '-', 'Z');
        throw new DateTimeException(new String(chars));
    }

    private OffsetDateTime seconds(int year, int month, int day, int hour, int minute, char[] chars) {
        int second = LimitedCharArrayIntegerUtil.parsePositiveInt(chars, 17, 19);
        int remaining = chars.length - 19;
        ZoneOffset offset = null;
        int fractions = 0;
        if (remaining == 1 && (chars[19] == 'Z' || chars[19] == 'z')) {
            offset = ZoneOffset.UTC;
            this.assertNoMoreChars(chars, 19);
        } else if (remaining >= 1 && chars[19] == '.') {
            int idx = LimitedCharArrayIntegerUtil.indexOfNonDigit(chars, 20);
            if (idx != -1) {
                int len = idx - 20;
                fractions = LimitedCharArrayIntegerUtil.parsePositiveInt(chars, 20, idx);
                if (len == 1) {
                    fractions *= 100000000;
                }
                if (len == 2) {
                    fractions *= 10000000;
                }
                if (len == 3) {
                    fractions *= 1000000;
                }
                if (len == 4) {
                    fractions *= 100000;
                }
                if (len == 5) {
                    fractions *= 10000;
                }
                if (len == 6) {
                    fractions *= 1000;
                }
                if (len == 7) {
                    fractions *= 100;
                }
                if (len == 8) {
                    fractions *= 10;
                }
                offset = this.parseTz(chars, idx);
            } else {
                offset = this.parseTz(chars, 20);
            }
        } else if (remaining >= 1 && (chars[19] == '+' || chars[19] == '-')) {
            offset = this.parseTz(chars, 19);
        } else {
            if (remaining == 0) {
                throw new DateTimeException("Unexpected end of expression at position 19 '" + new String(chars) + "'");
            }
            throw new DateTimeException("Unexpected character at position 19:" + chars[19]);
        }
        return OffsetDateTime.of(year, month, day, hour, minute, second, fractions, offset);
    }
}

