/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import java.util.ArrayList;

final class StridedIndexTypeCollection {
    private int m_firstFree = -1;
    private int m_last = 0;
    private int m_stride;
    private int m_realStride;
    private int m_realBlockSize;
    private int m_blockSize;
    private int m_blockMask;
    private int m_blockPower;
    private int m_size = 0;
    private int m_capacity;
    private ArrayList<int[]> m_buffer;
    static final int[] st_sizes = new int[]{16, 32, 64, 128, 256, 512, 1024, 2048};

    StridedIndexTypeCollection(int stride) {
        this.m_stride = stride;
        this.m_realStride = stride;
        this.m_realBlockSize = 2048;
        this.m_blockPower = 11;
        this.m_blockMask = 2047;
        this.m_blockSize = 2048 / this.m_realStride;
        this.m_capacity = 0;
        this.m_buffer = null;
    }

    void deleteElement(int element) {
        assert (this.dbgdelete_(element));
        int totalStrides = (element >> this.m_blockPower) * this.m_blockSize * this.m_realStride + (element & this.m_blockMask);
        if (totalStrides < this.m_last * this.m_realStride) {
            this.m_buffer.get((int)(element >> this.m_blockPower))[element & this.m_blockMask] = this.m_firstFree;
            this.m_firstFree = element;
        } else {
            assert (totalStrides == this.m_last * this.m_realStride);
            --this.m_last;
        }
        --this.m_size;
    }

    int getField(int element, int field) {
        return this.m_buffer.get(element >> this.m_blockPower)[(element & this.m_blockMask) + field];
    }

    void setField(int element, int field, int value) {
        this.m_buffer.get((int)(element >> this.m_blockPower))[(element & this.m_blockMask) + field] = value;
    }

    int getStride() {
        return this.m_stride;
    }

    int newElement() {
        int element = this.m_firstFree;
        if (element == -1) {
            if (this.m_last == this.m_capacity) {
                this.grow_(this.m_capacity != 0 ? (this.m_capacity + 1) * 3 / 2 : 1);
            }
            element = (this.m_last / this.m_blockSize << this.m_blockPower) + this.m_last % this.m_blockSize * this.m_realStride;
            ++this.m_last;
        } else {
            this.m_firstFree = this.m_buffer.get(element >> this.m_blockPower)[element & this.m_blockMask];
        }
        ++this.m_size;
        int[] ar = this.m_buffer.get(element >> this.m_blockPower);
        int ind = element & this.m_blockMask;
        for (int i = 0; i < this.m_stride; ++i) {
            ar[ind + i] = -1;
        }
        return element;
    }

    int elementToIndex(int element) {
        return (element >> this.m_blockPower) * this.m_blockSize + (element & this.m_blockMask) / this.m_realStride;
    }

    void deleteAll(boolean b_free_memory) {
        this.m_firstFree = -1;
        this.m_last = 0;
        this.m_size = 0;
        if (b_free_memory) {
            this.m_buffer = null;
            this.m_capacity = 0;
        }
    }

    int size() {
        return this.m_size;
    }

    void setCapacity(int capacity) {
        if (capacity > this.m_capacity) {
            this.grow_(capacity);
        }
    }

    int capacity() {
        return this.m_capacity;
    }

    void swap(int element1, int element2) {
        int[] ar1 = this.m_buffer.get(element1 >> this.m_blockPower);
        int[] ar2 = this.m_buffer.get(element2 >> this.m_blockPower);
        int ind1 = element1 & this.m_blockMask;
        int ind2 = element2 & this.m_blockMask;
        for (int i = 0; i < this.m_stride; ++i) {
            int tmp = ar1[ind1 + i];
            ar1[ind1 + i] = ar2[ind2 + i];
            ar2[ind2 + i] = tmp;
        }
    }

    void swapField(int element1, int element2, int field) {
        int[] ar1 = this.m_buffer.get(element1 >> this.m_blockPower);
        int[] ar2 = this.m_buffer.get(element2 >> this.m_blockPower);
        int ind1 = (element1 & this.m_blockMask) + field;
        int ind2 = (element2 & this.m_blockMask) + field;
        int tmp = ar1[ind1];
        ar1[ind1] = ar2[ind2];
        ar2[ind2] = tmp;
    }

    static int impossibleIndex2() {
        return -2;
    }

    static int impossibleIndex3() {
        return -3;
    }

    static boolean isValidElement(int element) {
        return element >= 0;
    }

    private boolean dbgdelete_(int element) {
        this.setField(element, 1, 2125315821);
        return true;
    }

    private void grow_(int newsize) {
        if (this.m_buffer == null) {
            this.m_buffer = new ArrayList();
        }
        assert (newsize > this.m_capacity);
        int nblocks = (newsize + this.m_blockSize - 1) / this.m_blockSize;
        this.m_buffer.ensureCapacity(nblocks);
        if (nblocks == 1) {
            int oldsz;
            int n = oldsz = this.m_capacity > 0 ? this.m_capacity : 0;
            assert (oldsz < newsize);
            int i = 0;
            int realnewsize = newsize * this.m_realStride;
            while (realnewsize > st_sizes[i]) {
                ++i;
            }
            int[] b = new int[st_sizes[i]];
            if (this.m_buffer.size() == 1) {
                System.arraycopy(this.m_buffer.get(0), 0, b, 0, this.m_size * this.m_realStride);
                this.m_buffer.set(0, b);
            } else {
                this.m_buffer.add(b);
            }
            this.m_capacity = b.length / this.m_realStride;
        } else {
            if (this.m_buffer.size() == 1 && this.m_buffer.get(0).length < this.m_realBlockSize) {
                int[] b = new int[this.m_realBlockSize];
                System.arraycopy(this.m_buffer.get(0), 0, b, 0, this.m_size * this.m_realStride);
                this.m_buffer.set(0, b);
                this.m_capacity = this.m_blockSize;
            }
            while (this.m_buffer.size() < nblocks) {
                this.m_buffer.add(new int[this.m_realBlockSize]);
                this.m_capacity += this.m_blockSize;
            }
        }
    }
}

