/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Clusterer;
import com.esri.core.geometry.Cracker;
import com.esri.core.geometry.EditShape;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.UserCancelException;

final class CrackAndCluster {
    private EditShape m_shape = null;
    private ProgressTracker m_progressTracker = null;
    private double m_tolerance;

    private CrackAndCluster(ProgressTracker progressTracker) {
        this.m_progressTracker = progressTracker;
    }

    public static boolean execute(EditShape shape, double tolerance, ProgressTracker progressTracker) {
        CrackAndCluster cracker = new CrackAndCluster(progressTracker);
        cracker.m_shape = shape;
        cracker.m_tolerance = tolerance;
        return cracker._do();
    }

    private boolean _cluster(double toleranceCluster) {
        boolean res = Clusterer.executeNonReciprocal(this.m_shape, toleranceCluster);
        return res;
    }

    private boolean _crack() {
        boolean res = Cracker.execute(this.m_shape, this.m_tolerance, this.m_progressTracker);
        return res;
    }

    private boolean _do() {
        double toleranceCluster = this.m_tolerance * Math.sqrt(2.0) * 1.00001;
        boolean bChanged = false;
        int max_iter = this.m_shape.getTotalPointCount() + 10 > 30 ? 1000 : (this.m_shape.getTotalPointCount() + 10) * (this.m_shape.getTotalPointCount() + 10);
        int iter = 0;
        while (true) {
            if (iter > max_iter) {
                throw new GeometryException("Internal Error: max number of iterations exceeded");
            }
            boolean bClustered = this._cluster(toleranceCluster);
            bChanged |= bClustered;
            boolean bFiltered = this.m_shape.filterClosePoints(toleranceCluster, true) != 0;
            bChanged |= bFiltered;
            boolean bCracked = this._crack();
            bChanged |= bCracked;
            if (!bCracked) break;
            if (this.m_progressTracker != null && !this.m_progressTracker.progress(-1, -1)) {
                throw new UserCancelException();
            }
            ++iter;
        }
        return bChanged;
    }
}

