/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.benchmarks;

import com.esotericsoftware.kryo.util.CuckooObjectMap;
import com.esotericsoftware.kryo.util.IdentityMap;
import com.esotericsoftware.kryo.util.ObjectMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.bytebuddy.ByteBuddy;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;

public class MapBenchmark {
    @Benchmark
    public void read(ReadBenchmarkState state, Blackhole blackhole) {
        state.read(blackhole);
    }

    @Benchmark
    public void miss(MissBenchmarkState state, Blackhole blackhole) {
        state.miss(blackhole);
    }

    @Benchmark
    public void write(WriteBenchmarkState state, Blackhole blackhole) {
        state.write(blackhole);
    }

    @Benchmark
    public void writeRead(WriteBenchmarkState state, Blackhole blackhole) {
        state.readWrite(blackhole);
    }

    private static MapAdapter<Object, Integer> createMap(MapType mapType, int initialCapacity, float loadFactor, int maxCapacity) {
        switch (mapType) {
            case cuckoo: {
                return new CuckooMapAdapter<Object>(new CuckooObjectMap(initialCapacity, loadFactor), maxCapacity);
            }
            case object: {
                return new ObjectMapAdapter<Object>(new ObjectMap(initialCapacity, loadFactor), maxCapacity);
            }
            case identity: {
                return new ObjectMapAdapter<Object>((ObjectMap<Object, Integer>)new IdentityMap(initialCapacity, loadFactor), maxCapacity);
            }
            case hash: {
                return new HashMapAdapter<Object>(new HashMap(initialCapacity, loadFactor));
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)mapType));
    }

    private static class HashMapAdapter<K>
    implements MapAdapter<K, Integer> {
        private final HashMap<K, Integer> delegate;

        public HashMapAdapter(HashMap<K, Integer> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Integer get(K key) {
            return this.delegate.get(key);
        }

        @Override
        public Integer put(K key, Integer value) {
            return this.delegate.put(key, value);
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }
    }

    static class CuckooMapAdapter<K>
    implements MapAdapter<K, Integer> {
        private final CuckooObjectMap<K, Integer> delegate;
        private final int maxCapacity;

        public CuckooMapAdapter(CuckooObjectMap<K, Integer> delegate, int maxCapacity) {
            this.delegate = delegate;
            this.maxCapacity = maxCapacity;
        }

        @Override
        public Integer get(K key) {
            return (Integer)this.delegate.get(key, (Object)-1);
        }

        @Override
        public Integer put(K key, Integer value) {
            this.delegate.put(key, (Object)value);
            return null;
        }

        @Override
        public void clear() {
            this.delegate.clear(this.maxCapacity);
        }
    }

    static class ObjectMapAdapter<K>
    implements MapAdapter<K, Integer> {
        private final ObjectMap<K, Integer> delegate;
        private final int maxCapacity;

        public ObjectMapAdapter(ObjectMap<K, Integer> delegate, int maxCapacity) {
            this.delegate = delegate;
            this.maxCapacity = maxCapacity;
        }

        @Override
        public Integer get(K key) {
            return (Integer)this.delegate.get(key, (Object)-1);
        }

        @Override
        public Integer put(K key, Integer value) {
            this.delegate.put(key, (Object)value);
            return null;
        }

        @Override
        public void clear() {
            this.delegate.clear(this.maxCapacity);
        }
    }

    static interface MapAdapter<K, V> {
        public V get(K var1);

        public V put(K var1, V var2);

        public void clear();
    }

    public static enum DataSource {
        integers{

            @Override
            Object getData(Random random) {
                return random.nextInt();
            }
        }
        ,
        strings{

            @Override
            Object getData(Random random) {
                int leftLimit = 97;
                int rightLimit = 122;
                int low = 10;
                int high = 100;
                int length = random.nextInt(high - low) + low;
                return random.ints(leftLimit, rightLimit + 1).limit(length).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
            }
        }
        ,
        classes{

            @Override
            Object getData(Random random) {
                return new ByteBuddy().subclass(Object.class).make().load(MapBenchmark.class.getClassLoader()).getLoaded();
            }
        };


        abstract Object getData(Random var1);

        public List<Object> buildData(Random random, int numClasses) {
            return IntStream.rangeClosed(0, numClasses).mapToObj(i -> this.getData(random)).collect(Collectors.toList());
        }
    }

    public static enum MapType {
        object,
        identity,
        cuckoo,
        hash;

    }

    @State(value=Scope.Thread)
    public static class WriteBenchmarkState
    extends AbstractBenchmarkState {
        final Random random = new Random(123L);

        @Setup(value=Level.Trial)
        public void setup() {
            this.map = MapBenchmark.createMap(this.mapType, this.initialCapacity, this.loadFactor, this.maxCapacity);
            this.data = this.dataSource.buildData(this.random, this.numClasses);
            Collections.shuffle(this.data);
        }

        public void write(Blackhole blackhole) {
            this.data.stream().map(c -> this.map.put(c, 1)).forEach(arg_0 -> ((Blackhole)blackhole).consume(arg_0));
        }

        public void readWrite(Blackhole blackhole) {
            this.data.forEach(c -> this.map.put(c, 1));
            Collections.shuffle(this.data);
            this.data.stream().limit(this.numClasses).map(this.map::get).forEach(arg_0 -> ((Blackhole)blackhole).consume(arg_0));
            this.map.clear();
        }
    }

    @State(value=Scope.Thread)
    public static class MissBenchmarkState
    extends AbstractBenchmarkState {
        final Random random = new Random(123L);
        private List<Object> moreData;

        @Setup(value=Level.Trial)
        public void setup() {
            this.map = MapBenchmark.createMap(this.mapType, this.initialCapacity, this.loadFactor, this.maxCapacity);
            this.data = this.dataSource.buildData(this.random, this.numClasses);
            this.data.forEach(c -> this.map.put(c, 1));
            this.moreData = this.dataSource.buildData(this.random, this.numClasses);
        }

        public void miss(Blackhole blackhole) {
            this.moreData.stream().map(this.map::get).forEach(arg_0 -> ((Blackhole)blackhole).consume(arg_0));
        }
    }

    @State(value=Scope.Thread)
    public static class ReadBenchmarkState
    extends AbstractBenchmarkState {
        final Random random = new Random(123L);

        @Setup(value=Level.Trial)
        public void setup() {
            this.map = MapBenchmark.createMap(this.mapType, this.initialCapacity, this.loadFactor, this.maxCapacity);
            this.data = this.dataSource.buildData(this.random, this.numClasses);
            this.data.forEach(c -> this.map.put(c, 1));
            Collections.shuffle(this.data);
        }

        public void read(Blackhole blackhole) {
            this.data.stream().limit(this.numClasses).map(this.map::get).forEach(arg_0 -> ((Blackhole)blackhole).consume(arg_0));
        }
    }

    @State(value=Scope.Thread)
    public static class AbstractBenchmarkState {
        @Param(value={"object", "identity", "cuckoo", "hash"})
        public MapType mapType;
        @Param(value={"integers", "strings", "classes"})
        public DataSource dataSource;
        @Param(value={"100", "500", "1000", "2500", "5000", "10000"})
        public int numClasses;
        @Param(value={"51"})
        public int initialCapacity;
        @Param(value={"0.7", "0.75", "0.8"})
        public float loadFactor;
        @Param(value={"8192"})
        public int maxCapacity;
        MapAdapter<Object, Integer> map;
        List<Object> data;
    }
}

