/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.benchmarks.io;

import com.esotericsoftware.kryo.benchmarks.io.InputOutputState;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;

@BenchmarkMode(value={Mode.SingleShotTime})
@Measurement(batchSize=12000000)
public class ArrayBenchmark {
    @Benchmark
    public void writeInts(WriteIntsState state) {
        state.reset();
        state.output.writeInts(state.ints, 0, state.ints.length);
    }

    @Benchmark
    public void readInts(ReadIntsState state) {
        state.reset();
        state.input.readInts(state.ints.length);
    }

    @Benchmark
    public void writeVarInts(WriteIntsState state) {
        state.reset();
        state.output.writeInts(state.ints, 0, state.ints.length, true);
    }

    @Benchmark
    public void readVarInts(ReadIntsState state) {
        state.reset();
        state.input.readInts(state.ints.length, true);
    }

    @Benchmark
    public void writeLongs(WriteLongsState state) {
        state.reset();
        state.output.writeLongs(state.longs, 0, state.longs.length);
    }

    @Benchmark
    public void readLongs(ReadLongsState state) {
        state.reset();
        state.input.readLongs(state.longs.length);
    }

    @Benchmark
    public void writeVarLongs(WriteLongsState state) {
        state.reset();
        state.output.writeLongs(state.longs, 0, state.longs.length, true);
    }

    @Benchmark
    public void readVarLongs(ReadLongsState state) {
        state.reset();
        state.input.readLongs(state.longs.length, true);
    }

    @State(value=Scope.Thread)
    public static class ReadLongsState
    extends WriteLongsState {
        @Override
        public void setup() {
            super.setup();
            new ArrayBenchmark().writeLongs(this);
        }
    }

    @State(value=Scope.Thread)
    public static class WriteLongsState
    extends InputOutputState {
        public long[] longs = new long[]{0L, 1L, 2L, 3L, 4L, 5L, 63L, 64L, 65L, 127L, 128L, 129L, 4000L, 5000L, 6000L, 16000L, 32000L, 256000L, 1024000L, -1L, -2L, -3L, -4L, Integer.MIN_VALUE, Integer.MAX_VALUE, Long.MIN_VALUE, Long.MAX_VALUE, 9999999999L};

        @Override
        public void setup() {
            super.setup();
            new ArrayBenchmark().writeLongs(this);
        }
    }

    @State(value=Scope.Thread)
    public static class ReadIntsState
    extends WriteIntsState {
        @Override
        public void setup() {
            super.setup();
            new ArrayBenchmark().writeInts(this);
        }
    }

    @State(value=Scope.Thread)
    public static class WriteIntsState
    extends InputOutputState {
        public int[] ints = new int[]{0, 1, 2, 3, 4, 5, 63, 64, 65, 127, 128, 129, 4000, 5000, 6000, 16000, 32000, 256000, 1024000, -1, -2, -3, -4, Integer.MIN_VALUE, Integer.MAX_VALUE};
    }
}

