/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.security.filters;

import com.erudika.para.core.App;
import com.erudika.para.core.ParaObject;
import com.erudika.para.core.User;
import com.erudika.para.core.utils.CoreUtils;
import com.erudika.para.core.utils.Para;
import com.erudika.para.server.security.AuthenticatedUserDetails;
import com.erudika.para.server.security.SecurityUtils;
import com.erudika.para.server.security.UserAuthentication;
import com.nimbusds.jwt.SignedJWT;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.text.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;

public class PasswordlessAuthFilter
extends AbstractAuthenticationProcessingFilter {
    private static final Logger logger = LoggerFactory.getLogger(PasswordlessAuthFilter.class);
    public static final String PASSWORDLESS_ACTION = "passwordless_auth";

    public PasswordlessAuthFilter(String defaultFilterProcessesUrl) {
        super(defaultFilterProcessesUrl);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String requestURI = request.getServletPath();
        UserAuthentication userAuth = null;
        boolean redirect = !"false".equals(request.getParameter("redirect"));
        User user = null;
        App app = null;
        if (requestURI.endsWith(PASSWORDLESS_ACTION)) {
            String appid = SecurityUtils.getAppidFromAuthRequest(request);
            String token = request.getParameter("token");
            app = (App)Para.getDAO().read(App.id((String)appid));
            if (app != null && (userAuth = this.getOrCreateUser(app, token)) != null) {
                user = ((AuthenticatedUserDetails)userAuth.getPrincipal()).getUser();
                user.setAppid(app.getAppIdentifier());
            }
        }
        UserAuthentication auth = SecurityUtils.checkIfActive(userAuth, user, redirect);
        if (!redirect) {
            if (auth == null) {
                response.sendError(HttpStatus.FORBIDDEN.value());
                response.setStatus(HttpStatus.FORBIDDEN.value());
            } else {
                response.setContentType("text/plain");
                response.setStatus(HttpStatus.OK.value());
                response.getWriter().print(SecurityUtils.generateJWToken(user, app).serialize());
            }
            return null;
        }
        return auth;
    }

    public UserAuthentication getOrCreateUser(App app, String accessToken) {
        UserAuthentication userAuth = null;
        User user = new User();
        String secret = Para.getConfig().getSettingForApp(app, "app_secret_key", app.getSecret());
        try {
            String userSecret;
            SignedJWT jwt = SignedJWT.parse((String)accessToken);
            String email = jwt.getJWTClaimsSet().getStringClaim("email");
            String name = jwt.getJWTClaimsSet().getStringClaim("name");
            String identifier = jwt.getJWTClaimsSet().getStringClaim("identifier");
            String groups = jwt.getJWTClaimsSet().getStringClaim("groups");
            String picture = jwt.getJWTClaimsSet().getStringClaim("picture");
            String appid = app.getAppIdentifier();
            User u = new User();
            u.setAppid(appid);
            u.setIdentifier(identifier);
            u.setEmail(email);
            user = User.readUserForIdentifier((User)u);
            String string = userSecret = user != null ? user.getTokenSecret() : "";
            if (SecurityUtils.isValidJWToken(secret, jwt) || SecurityUtils.isValidJWToken(app.getSecret() + userSecret, jwt)) {
                if (user == null) {
                    user = new User();
                    user.setActive(Boolean.valueOf(true));
                    user.setAppid(appid);
                    user.setName(name);
                    user.setGroups(StringUtils.isBlank((CharSequence)groups) ? User.Groups.USERS.toString() : groups);
                    user.setIdentifier(identifier);
                    user.setEmail(email);
                    user.setPicture(picture);
                    user.create();
                } else if (this.updateUserInfo(user, picture, email, name, accessToken, groups)) {
                    user.update();
                }
                userAuth = new UserAuthentication(new AuthenticatedUserDetails(user));
            } else {
                logger.info("Authentication request failed because the provided JWT token is invalid. appid: '" + app.getAppIdentifier() + "', user found: " + (user == null ? "none" : user.getId()) + ", user queried: " + identifier);
            }
        }
        catch (ParseException e) {
            logger.warn("Invalid token: " + e.getMessage());
        }
        return SecurityUtils.checkIfActive(userAuth, user, false);
    }

    private boolean updateUserInfo(User user, String picture, String email, String name, String accessToken, String groups) {
        boolean update = false;
        if (!StringUtils.equals((CharSequence)user.getPicture(), (CharSequence)picture)) {
            user.setPicture(picture);
            update = true;
        }
        if (!StringUtils.isBlank((CharSequence)email) && !StringUtils.equals((CharSequence)user.getEmail(), (CharSequence)email)) {
            user.setEmail(email);
            update = true;
        }
        if (!StringUtils.isBlank((CharSequence)name) && !StringUtils.equals((CharSequence)user.getName(), (CharSequence)name)) {
            user.setName(name);
            update = true;
        }
        if (!StringUtils.isBlank((CharSequence)groups) && !StringUtils.equals((CharSequence)user.getGroups(), (CharSequence)groups)) {
            user.setGroups(groups);
            CoreUtils.getInstance().overwrite(user.getAppid(), (ParaObject)user);
            update = false;
        }
        return update;
    }
}

