/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.security.filters;

import com.erudika.para.core.App;
import com.erudika.para.core.User;
import com.erudika.para.core.utils.Para;
import com.erudika.para.core.utils.ParaObjectUtils;
import com.erudika.para.core.utils.Utils;
import com.erudika.para.server.security.AuthenticatedUserDetails;
import com.erudika.para.server.security.SecurityUtils;
import com.erudika.para.server.security.UserAuthentication;
import com.fasterxml.jackson.databind.ObjectReader;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;

public class MicrosoftAuthFilter
extends AbstractAuthenticationProcessingFilter {
    private static final Logger logger = LoggerFactory.getLogger(MicrosoftAuthFilter.class);
    private final CloseableHttpClient httpclient;
    private final ObjectReader jreader = ParaObjectUtils.getJsonReader(Map.class);
    private static final String PROFILE_URL = "https://graph.microsoft.com/v1.0/me";
    private static final String PHOTO_URL = "https://graph.microsoft.com/v1.0/me/photo/$value";
    private static final String TOKEN_URL = "https://login.microsoftonline.com/{0}/oauth2/v2.0/token";
    private static final String PAYLOAD = "code={0}&redirect_uri={1}&scope=https%3A%2F%2Fgraph.microsoft.com%2Fuser.read&client_id={2}&client_secret={3}&grant_type=authorization_code";
    public static final String MICROSOFT_ACTION = "microsoft_auth";

    public MicrosoftAuthFilter(String defaultFilterProcessesUrl) {
        super(defaultFilterProcessesUrl);
        int timeout = 30;
        this.httpclient = HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout((long)timeout, TimeUnit.SECONDS).build()).build();
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String authCode;
        String requestURI = request.getServletPath();
        UserAuthentication userAuth = null;
        if (requestURI.endsWith(MICROSOFT_ACTION) && !StringUtils.isBlank((CharSequence)(authCode = request.getParameter("code")))) {
            String appid = SecurityUtils.getAppidFromAuthRequest(request);
            String redirectURI = SecurityUtils.getRedirectUrl(request);
            App app = (App)Para.getDAO().read(App.id((String)(appid == null ? Para.getConfig().getRootAppIdentifier() : appid)));
            String[] keys = Para.getConfig().getOAuthKeysForApp(app, "ms:");
            String entity = Utils.formatMessage((String)PAYLOAD, (Object[])new Object[]{authCode, Utils.urlEncode((String)redirectURI), keys[0], keys[1]});
            HttpPost tokenPost = new HttpPost(Utils.formatMessage((String)TOKEN_URL, (Object[])new Object[]{Para.getConfig().getSettingForApp(app, "ms_tenant_id", "common")}));
            tokenPost.setHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
            tokenPost.setEntity((HttpEntity)new StringEntity(entity));
            userAuth = (UserAuthentication)this.httpclient.execute((ClassicHttpRequest)tokenPost, resp1 -> {
                if (resp1 != null && resp1.getEntity() != null) {
                    Map token = (Map)this.jreader.readValue(resp1.getEntity().getContent());
                    if (token != null && token.containsKey("access_token")) {
                        return this.getOrCreateUser(app, (String)token.get("access_token"));
                    }
                    logger.info("Authentication request failed with status '" + resp1.getReasonPhrase() + "' - " + String.valueOf(token));
                    EntityUtils.consumeQuietly((HttpEntity)resp1.getEntity());
                } else {
                    logger.info("Authentication request failed with status '" + (resp1 != null ? resp1.getReasonPhrase() : "null") + "' and empty response body.");
                }
                return null;
            });
        }
        return SecurityUtils.checkIfActive(userAuth, SecurityUtils.getAuthenticatedUser(userAuth), true);
    }

    public UserAuthentication getOrCreateUser(App app, String accessToken) throws IOException {
        if (accessToken == null) {
            return SecurityUtils.checkIfActive(null, null, false);
        }
        HttpGet profileGet = new HttpGet(PROFILE_URL);
        profileGet.setHeader("Authorization", (Object)("Bearer " + accessToken));
        profileGet.setHeader("Accept", (Object)"application/json");
        return (UserAuthentication)this.httpclient.execute((ClassicHttpRequest)profileGet, resp2 -> {
            UserAuthentication userAuth = null;
            User user = new User();
            Map profile = null;
            HttpEntity respEntity = resp2.getEntity();
            if (respEntity != null) {
                profile = (Map)this.jreader.readValue(respEntity.getContent());
                EntityUtils.consumeQuietly((HttpEntity)respEntity);
            }
            if (profile != null && profile.containsKey("id")) {
                String microsoftId = (String)profile.get("id");
                String email = this.getEmail(profile);
                String name = (String)profile.get("displayName");
                user.setAppid(this.getAppid(app));
                user.setIdentifier("ms:" + microsoftId);
                user.setEmail(email);
                user = User.readUserForIdentifier((User)user);
                if (user == null) {
                    user = new User(Utils.getNewId());
                    user.setActive(Boolean.valueOf(true));
                    user.setAppid(this.getAppid(app));
                    user.setEmail((String)(StringUtils.isBlank((CharSequence)email) ? Utils.getNewId() + "@windowslive.com" : email));
                    user.setName(StringUtils.isBlank((CharSequence)name) ? "No Name" : name);
                    user.setPassword(Utils.generateSecurityToken());
                    user.setPicture(this.getPicture(this.getAppid(app), user.getId(), accessToken, email));
                    user.setIdentifier("ms:" + microsoftId);
                    String id = user.create();
                    if (id == null) {
                        throw new AuthenticationServiceException("Authentication failed: cannot create new user.");
                    }
                } else if (this.updateUserInfo(user, email, name, accessToken, this.getAppid(app))) {
                    user.update();
                }
                userAuth = new UserAuthentication(new AuthenticatedUserDetails(user));
            } else {
                logger.info("Authentication request failed because user profile doesn't contain the expected attributes");
            }
            return SecurityUtils.checkIfActive(userAuth, user, false);
        });
    }

    private boolean updateUserInfo(User user, String email, String name, String accessToken, String appid) throws IOException {
        String picture = this.getPicture(appid, user.getId(), accessToken, email);
        boolean update = false;
        if (!StringUtils.equals((CharSequence)user.getPicture(), (CharSequence)picture)) {
            user.setPicture(picture);
            update = true;
        }
        if (!StringUtils.isBlank((CharSequence)email) && !StringUtils.equals((CharSequence)user.getEmail(), (CharSequence)email)) {
            user.setEmail(email);
            update = true;
        }
        if (!StringUtils.isBlank((CharSequence)name) && !StringUtils.equals((CharSequence)user.getName(), (CharSequence)name)) {
            user.setName(name);
            update = true;
        }
        return update;
    }

    private String getPicture(String appid, String userid, String accessToken, String email) throws IOException {
        String pic = this.getGravatar(email);
        if (accessToken != null) {
            HttpGet profileGet = new HttpGet(PHOTO_URL);
            profileGet.setHeader("Authorization", (Object)("Bearer " + accessToken));
            profileGet.setHeader("Accept", (Object)"application/json");
            pic = (String)this.httpclient.execute((ClassicHttpRequest)profileGet, resp -> {
                HttpEntity respEntity = resp.getEntity();
                if (respEntity != null && respEntity.getContentType().startsWith("image")) {
                    String ctype = respEntity.getContentType();
                    return Para.getFileStore().store(Optional.ofNullable(appid).orElse("para") + "/" + userid + "." + StringUtils.substringAfter((String)ctype, (String)"/"), respEntity.getContent());
                }
                EntityUtils.consumeQuietly((HttpEntity)respEntity);
                return this.getGravatar(email);
            });
        }
        return pic;
    }

    private String getGravatar(String email) {
        return "https://www.gravatar.com/avatar/" + Utils.md5((String)email.toLowerCase()) + "?size=400&d=mm&r=pg";
    }

    private String getEmail(Map<String, Object> profile) {
        String email = (String)profile.get("mail");
        if (StringUtils.isBlank((CharSequence)email) || !StringUtils.contains((CharSequence)email, (CharSequence)"@")) {
            email = (String)profile.get("userPrincipalName");
        }
        return email;
    }

    private String getAppid(App app) {
        return app == null ? null : app.getAppIdentifier();
    }
}

