/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.security.filters;

import com.erudika.para.core.App;
import com.erudika.para.core.User;
import com.erudika.para.core.utils.Para;
import com.erudika.para.core.utils.ParaObjectUtils;
import com.erudika.para.core.utils.Utils;
import com.erudika.para.server.security.AuthenticatedUserDetails;
import com.erudika.para.server.security.SecurityUtils;
import com.erudika.para.server.security.UserAuthentication;
import com.fasterxml.jackson.databind.ObjectReader;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;

public class AmazonAuthFilter
extends AbstractAuthenticationProcessingFilter {
    private static final Logger logger = LoggerFactory.getLogger(AmazonAuthFilter.class);
    private final CloseableHttpClient httpclient;
    private final ObjectReader jreader = ParaObjectUtils.getJsonReader(Map.class);
    private static final String PROFILE_URL = "https://api.amazon.com/user/profile";
    private static final String TOKEN_URL = "https://api.amazon.com/auth/o2/token";
    private static final String PAYLOAD = "code={0}&redirect_uri={1}&client_id={2}&client_secret={3}&grant_type=authorization_code";
    public static final String AMAZON_ACTION = "amazon_auth";

    public AmazonAuthFilter(String defaultFilterProcessesUrl) {
        super(defaultFilterProcessesUrl);
        int timeout = 30;
        this.httpclient = HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout((long)timeout, TimeUnit.SECONDS).build()).build();
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String authCode;
        String requestURI = request.getServletPath();
        UserAuthentication userAuth = null;
        if (requestURI.endsWith(AMAZON_ACTION) && !StringUtils.isBlank((CharSequence)(authCode = request.getParameter("code")))) {
            String appid = SecurityUtils.getAppidFromAuthRequest(request);
            String redirectURI = SecurityUtils.getRedirectUrl(request);
            App app = (App)Para.getDAO().read(App.id((String)(appid == null ? Para.getConfig().getRootAppIdentifier() : appid)));
            String[] keys = Para.getConfig().getOAuthKeysForApp(app, "az:");
            String entity = Utils.formatMessage((String)PAYLOAD, (Object[])new Object[]{authCode, Utils.urlEncode((String)redirectURI), keys[0], keys[1]});
            HttpPost tokenPost = new HttpPost(TOKEN_URL);
            tokenPost.setHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
            tokenPost.setHeader("Accept", (Object)"application/json");
            tokenPost.setEntity((HttpEntity)new StringEntity(entity));
            userAuth = (UserAuthentication)this.httpclient.execute((ClassicHttpRequest)tokenPost, resp1 -> {
                if (resp1 != null && resp1.getEntity() != null) {
                    Map token = (Map)this.jreader.readValue(resp1.getEntity().getContent());
                    if (token != null && token.containsKey("access_token")) {
                        return this.getOrCreateUser(app, (String)token.get("access_token"));
                    }
                    logger.info("Authentication request failed with status '" + resp1.getReasonPhrase() + "' - " + String.valueOf(token));
                    EntityUtils.consumeQuietly((HttpEntity)resp1.getEntity());
                } else {
                    logger.info("Authentication request failed with status '" + (resp1 != null ? resp1.getReasonPhrase() : "null") + "' and empty response body.");
                }
                return null;
            });
        }
        return SecurityUtils.checkIfActive(userAuth, SecurityUtils.getAuthenticatedUser(userAuth), true);
    }

    public UserAuthentication getOrCreateUser(App app, String accessToken) throws IOException {
        if (accessToken == null) {
            return SecurityUtils.checkIfActive(null, null, false);
        }
        HttpGet profileGet = new HttpGet(PROFILE_URL);
        profileGet.setHeader("Accept", (Object)"application/json");
        profileGet.setHeader("x-amz-access-token", (Object)accessToken);
        return (UserAuthentication)this.httpclient.execute((ClassicHttpRequest)profileGet, resp2 -> {
            UserAuthentication userAuth = null;
            User user = new User();
            Map profile = null;
            HttpEntity respEntity = resp2.getEntity();
            if (respEntity != null) {
                profile = (Map)this.jreader.readValue(respEntity.getContent());
                EntityUtils.consumeQuietly((HttpEntity)respEntity);
            }
            if (profile != null && profile.containsKey("user_id")) {
                String amazonId = (String)profile.get("user_id");
                String email = (String)profile.get("email");
                String name = (String)profile.get("name");
                user.setAppid(this.getAppid(app));
                user.setIdentifier("az:" + amazonId);
                user.setEmail(email);
                user = User.readUserForIdentifier((User)user);
                if (user == null) {
                    user = new User();
                    user.setActive(Boolean.valueOf(true));
                    user.setAppid(this.getAppid(app));
                    user.setEmail((String)(StringUtils.isBlank((CharSequence)email) ? Utils.getNewId() + "@amazon.com" : email));
                    user.setName(StringUtils.isBlank((CharSequence)name) ? "No Name" : name);
                    user.setPassword(Utils.generateSecurityToken());
                    user.setPicture("https://www.gravatar.com/avatar/" + Utils.md5((String)email) + "?d=mm&size=400");
                    user.setIdentifier("az:" + amazonId);
                    this.updateIdpAccessToken(user, accessToken);
                    String id = user.create();
                    if (id == null) {
                        throw new AuthenticationServiceException("Authentication failed: cannot create new user.");
                    }
                } else if (this.updateUserInfo(user, email, name, accessToken)) {
                    user.update();
                }
                userAuth = new UserAuthentication(new AuthenticatedUserDetails(user));
            } else {
                logger.info("Authentication request failed because user profile doesn't contain the expected attributes");
            }
            return SecurityUtils.checkIfActive(userAuth, user, false);
        });
    }

    private boolean updateUserInfo(User user, String email, String name, String accessToken) throws UnsupportedEncodingException {
        boolean update = false;
        if (!StringUtils.isBlank((CharSequence)email) && !StringUtils.equals((CharSequence)user.getEmail(), (CharSequence)email)) {
            user.setEmail(email);
            update = true;
        }
        if (!StringUtils.isBlank((CharSequence)name) && !StringUtils.equals((CharSequence)user.getName(), (CharSequence)name)) {
            user.setName(name);
            update = true;
        }
        return this.updateIdpAccessToken(user, accessToken) || update;
    }

    private boolean updateIdpAccessToken(User user, String accessToken) throws UnsupportedEncodingException {
        String payload = "{\"access_token\":\"" + accessToken + "\"}";
        if (!payload.equals(Utils.base64dec((String)user.getIdpAccessTokenPayload()))) {
            user.setIdpAccessToken("eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9." + Utils.base64enc((byte[])payload.getBytes(Para.getConfig().defaultEncoding())) + ".Ss");
            return true;
        }
        return false;
    }

    private String getAppid(App app) {
        return app == null ? null : app.getAppIdentifier();
    }
}

