/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.security;

import com.erudika.para.core.App;
import com.erudika.para.core.User;
import com.erudika.para.core.utils.Para;
import com.erudika.para.core.utils.Utils;
import com.erudika.para.server.rest.RestUtils;
import com.erudika.para.server.security.AjaxRequestMatcher;
import com.erudika.para.server.security.RestRequestMatcher;
import com.erudika.para.server.security.SecurityUtils;
import com.erudika.para.server.utils.HttpUtils;
import com.nimbusds.jwt.SignedJWT;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationSuccessHandler;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class SimpleAuthenticationSuccessHandler
extends SimpleUrlAuthenticationSuccessHandler {
    private RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        App app;
        User u = SecurityUtils.getAuthenticatedUser(authentication);
        String appid = SecurityUtils.getAppidFromAuthRequest(request);
        if (!StringUtils.isBlank((CharSequence)appid) && (app = (App)Para.getDAO().read(App.id((String)appid))) != null) {
            SignedJWT newJWT;
            Object customURI = (String)app.getSetting("signin_success");
            Set<String> hostUrlAliases = SecurityUtils.getHostUrlAliasesForReturn(app);
            String hostUrlParam = SecurityUtils.getHostUrlFromQueryStringOrStateParam(hostUrlAliases, request);
            if (app.isRootApp() && StringUtils.isBlank((CharSequence)customURI)) {
                customURI = Para.getConfig().signinSuccessPath();
            }
            if (!StringUtils.isBlank((CharSequence)hostUrlParam)) {
                if (hostUrlAliases.contains(hostUrlParam) || StringUtils.startsWith((CharSequence)customURI, (CharSequence)hostUrlParam)) {
                    UriComponents hostUrl = UriComponentsBuilder.fromUriString((String)hostUrlParam).build();
                    customURI = UriComponentsBuilder.fromUriString((String)customURI).host(hostUrl.getHost()).toUriString();
                } else {
                    UriComponents customHost = UriComponentsBuilder.fromUriString((String)customURI).build();
                    customURI = customHost.getScheme() + "://" + customHost.getHost();
                }
            }
            if (StringUtils.contains((CharSequence)customURI, (CharSequence)"jwt=?")) {
                newJWT = SecurityUtils.generateJWToken(u, app);
                customURI = ((String)customURI).replace("jwt=?", "jwt=" + newJWT.serialize());
            }
            if (StringUtils.contains((CharSequence)customURI, (CharSequence)"jwt=id")) {
                newJWT = SecurityUtils.generateIdToken(u, app);
                customURI = ((String)customURI).replace("jwt=id", "jwt=" + newJWT.serialize());
            }
            if (!StringUtils.isBlank((CharSequence)customURI)) {
                this.redirectStrategy.sendRedirect(request, response, (String)customURI);
                return;
            }
        }
        if (this.isRestRequest(request)) {
            RestUtils.returnStatusResponse(response, 204, "Authentication success.");
        } else {
            super.onAuthenticationSuccess(request, response, authentication);
        }
    }

    protected String determineTargetUrl(HttpServletRequest request, HttpServletResponse response) {
        String cookie = HttpUtils.getStateParam(Para.getConfig().returnToCookieName(), request);
        if (cookie != null) {
            cookie = Utils.base64dec((String)cookie);
            HttpUtils.removeStateParam(Para.getConfig().returnToCookieName(), request, response);
            return cookie;
        }
        return super.determineTargetUrl(request, response);
    }

    protected boolean isRestRequest(HttpServletRequest request) {
        return RestRequestMatcher.INSTANCE.matches(request) || AjaxRequestMatcher.INSTANCE.matches(request);
    }
}

