/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.security;

import com.erudika.para.core.App;
import com.erudika.para.core.utils.Para;
import com.erudika.para.server.rest.RestUtils;
import com.erudika.para.server.security.AjaxRequestMatcher;
import com.erudika.para.server.security.RestRequestMatcher;
import com.erudika.para.server.security.SecurityUtils;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class SimpleAuthenticationFailureHandler
extends SimpleUrlAuthenticationFailureHandler {
    private RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        App app;
        String appid = SecurityUtils.getAppidFromAuthRequest(request);
        if (!StringUtils.isBlank((CharSequence)appid) && (app = (App)Para.getDAO().read(App.id((String)appid))) != null) {
            Object customURI = (String)app.getSetting("signin_failure");
            Set<String> hostUrlAliases = SecurityUtils.getHostUrlAliasesForReturn(app);
            String hostUrlParam = SecurityUtils.getHostUrlFromQueryStringOrStateParam(hostUrlAliases, request);
            if (app.isRootApp() && StringUtils.isBlank((CharSequence)customURI)) {
                customURI = Para.getConfig().signinFailurePath();
            }
            if (!StringUtils.isBlank((CharSequence)hostUrlParam)) {
                if (hostUrlAliases.contains(hostUrlParam) || StringUtils.startsWith((CharSequence)customURI, (CharSequence)hostUrlParam)) {
                    UriComponents hostUrl = UriComponentsBuilder.fromUriString((String)hostUrlParam).build();
                    customURI = UriComponentsBuilder.fromUriString((String)customURI).host(hostUrl.getHost()).toUriString();
                } else {
                    UriComponents customHost = UriComponentsBuilder.fromUriString((String)customURI).build();
                    customURI = customHost.getScheme() + "://" + customHost.getHost();
                }
            }
            if (StringUtils.contains((CharSequence)customURI, (CharSequence)"cause=?")) {
                customURI = ((String)customURI).replace("cause=?", "cause=" + exception.getMessage());
            }
            if (!StringUtils.isBlank((CharSequence)customURI)) {
                this.redirectStrategy.sendRedirect(request, response, (String)customURI);
                return;
            }
        }
        if (this.isRestRequest(request)) {
            RestUtils.returnStatusResponse(response, 401, exception.getMessage());
        } else {
            super.onAuthenticationFailure(request, response, exception);
        }
    }

    protected boolean isRestRequest(HttpServletRequest request) {
        return RestRequestMatcher.INSTANCE.matches(request) || AjaxRequestMatcher.INSTANCE.matches(request);
    }
}

