/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.security;

import com.erudika.para.core.App;
import com.erudika.para.core.User;
import com.erudika.para.core.rest.Signer;
import com.erudika.para.core.utils.Para;
import com.erudika.para.core.utils.Utils;
import com.erudika.para.server.rest.RestUtils;
import com.erudika.para.server.security.AppAuthentication;
import com.erudika.para.server.security.JWTAuthentication;
import com.erudika.para.server.security.RestRequestMatcher;
import com.erudika.para.server.security.SecurityUtils;
import com.erudika.para.server.utils.BufferedRequestWrapper;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;

public class RestAuthFilter
extends GenericFilterBean
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityUtils.class);
    private final boolean apiSecurityEnabled;

    public RestAuthFilter() {
        this.apiSecurityEnabled = true;
    }

    public RestAuthFilter(boolean apiSecurityEnabled) {
        this.apiSecurityEnabled = apiSecurityEnabled;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        BufferedRequestWrapper request = new BufferedRequestWrapper((HttpServletRequest)req);
        HttpServletResponse response = (HttpServletResponse)res;
        boolean proceed = true;
        try {
            String appid = RestUtils.extractAccessKey((HttpServletRequest)request);
            boolean isApp = !StringUtils.isBlank((CharSequence)appid);
            boolean isGuest = RestUtils.isAnonymousRequest((HttpServletRequest)request);
            if (isGuest && RestRequestMatcher.INSTANCE.matches((HttpServletRequest)request)) {
                proceed = this.guestAuthRequestHandler(appid, (HttpServletRequest)req, response);
            } else if (!isApp && RestRequestMatcher.INSTANCE.matches((HttpServletRequest)request)) {
                proceed = this.userAuthRequestHandler((HttpServletRequest)req, response);
            } else if (isApp && RestRequestMatcher.INSTANCE_STRICT.matches((HttpServletRequest)request)) {
                proceed = this.appAuthRequestHandler(appid, (HttpServletRequest)request, response);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to authorize request.", (Throwable)e);
        }
        if (proceed || !this.apiSecurityEnabled) {
            chain.doFilter((ServletRequest)request, res);
        }
    }

    private boolean guestAuthRequestHandler(String appid, HttpServletRequest request, HttpServletResponse response) {
        String reqUri = request.getRequestURI();
        String method = request.getMethod();
        if (!StringUtils.isBlank((CharSequence)appid)) {
            App parentApp = (App)Para.getDAO().read(App.id((String)appid));
            if (this.hasPermission(parentApp, null, request)) {
                SecurityContextHolder.getContext().setAuthentication((Authentication)new AppAuthentication(parentApp));
                return true;
            }
            RestUtils.returnStatusResponse(response, 403, Utils.formatMessage((String)"You don't have permission to access this resource. [user: {0}, resource: {1} {2}]", (Object[])new Object[]{"[GUEST]", method, reqUri}));
            return false;
        }
        RestUtils.returnStatusResponse(response, 401, Utils.formatMessage((String)"You don't have permission to access this resource. [{0} {1}]", (Object[])new Object[]{method, reqUri}));
        return false;
    }

    private boolean userAuthRequestHandler(HttpServletRequest request, HttpServletResponse response) {
        Authentication userAuth = SecurityContextHolder.getContext().getAuthentication();
        User user = SecurityUtils.getAuthenticatedUser(userAuth);
        String reqUri = request.getRequestURI();
        String method = request.getMethod();
        App parentApp = userAuth instanceof JWTAuthentication ? ((JWTAuthentication)userAuth).getApp() : SecurityUtils.getAuthenticatedApp();
        if (userAuth != null) {
            if (user == null) {
                Object[] fail = this.doAppChecks(parentApp, request);
                if (fail == null) {
                    return true;
                }
                RestUtils.returnStatusResponse(response, (Integer)fail[0], (String)fail[1]);
                return false;
            }
            if (user.getActive().booleanValue()) {
                if (parentApp == null) {
                    parentApp = (App)Para.getDAO().read(App.id((String)user.getAppid()));
                }
                if (this.hasPermission(parentApp, user, request)) {
                    return true;
                }
                RestUtils.returnStatusResponse(response, 403, Utils.formatMessage((String)"You don't have permission to access this resource. [user: {0}, resource: {1} {2}]", (Object[])new Object[]{user.getId(), method, reqUri}));
                return false;
            }
        }
        RestUtils.returnStatusResponse(response, 401, Utils.formatMessage((String)"You don't have permission to access this resource. [{0} {1}]", (Object[])new Object[]{method, reqUri}));
        return false;
    }

    private boolean appAuthRequestHandler(String appid, HttpServletRequest request, HttpServletResponse response) {
        boolean requestExpired;
        String date = RestUtils.extractDate(request);
        Date d = Signer.parseAWSDate((String)date);
        boolean bl = requestExpired = d != null && System.currentTimeMillis() > d.getTime() + (long)(Para.getConfig().requestExpiresAfterSec() * 1000);
        if (this.apiSecurityEnabled && (StringUtils.isBlank((CharSequence)date) || requestExpired)) {
            RestUtils.returnStatusResponse(response, 400, "Request has expired.");
            return false;
        }
        App app = (App)Para.getDAO().read(App.id((String)appid));
        Object[] failures = this.doAppChecks(app, request);
        if (failures == null) {
            if (!this.apiSecurityEnabled || SecurityUtils.isValidSignature(request, app.getSecret())) {
                SecurityContextHolder.getContext().setAuthentication((Authentication)new AppAuthentication(app));
                return true;
            }
            RestUtils.returnStatusResponse(response, 403, Utils.formatMessage((String)"Invalid signature for request {0} {1} coming from app {2}", (Object[])new Object[]{request.getMethod(), request.getRequestURI(), app.getAppIdentifier()}));
            LOG.warn("Invalid signature for request {} {} coming from app '{}' ({})", new Object[]{request.getMethod(), request.getRequestURI() + (String)(StringUtils.isBlank((CharSequence)request.getQueryString()) ? "" : "?" + request.getQueryString()), app.getAppIdentifier(), request.getHeader("User-Agent")});
        } else {
            RestUtils.returnStatusResponse(response, (Integer)failures[0], (String)failures[1]);
        }
        return false;
    }

    private boolean hasPermission(App parentApp, User user, HttpServletRequest request) {
        if (parentApp == null) {
            return false;
        }
        if (user != null && user.isAdmin()) {
            return true;
        }
        String resourcePath = RestUtils.extractResourcePath(request);
        if (resourcePath.matches("^_permissions/.+") && request.getMethod().equals("GET")) {
            return true;
        }
        String subjectid = user == null ? "" : user.getId();
        return parentApp.isAllowedTo(subjectid, resourcePath, request.getMethod());
    }

    private Object[] doAppChecks(App app, HttpServletRequest request) {
        if (app == null) {
            return new Object[]{404, "App not found."};
        }
        if (!app.getActive().booleanValue()) {
            return new Object[]{403, Utils.formatMessage((String)"App not active. [{0}]", (Object[])new Object[]{app.getId()})};
        }
        if (app.getReadOnly().booleanValue() && this.isWriteRequest(request)) {
            return new Object[]{403, Utils.formatMessage((String)"App is in read-only mode. [{0}]", (Object[])new Object[]{app.getId()})};
        }
        return null;
    }

    private boolean isWriteRequest(HttpServletRequest req) {
        return req != null && ("POST".equals(req.getMethod()) || "PUT".equals(req.getMethod()) || "DELETE".equals(req.getMethod()) || "PATCH".equals(req.getMethod()));
    }
}

