/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.security;

import com.erudika.para.core.utils.Para;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigValue;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public final class IgnoredRequestMatcher
implements RequestMatcher {
    public static final RequestMatcher INSTANCE = new IgnoredRequestMatcher();
    private final OrRequestMatcher orMatcher;

    private IgnoredRequestMatcher() {
        ConfigList c = Para.getConfig().ignoredPaths();
        ArrayList<PathPatternRequestMatcher> list = new ArrayList<PathPatternRequestMatcher>();
        if (c != null) {
            for (ConfigValue configValue : c) {
                list.add(PathPatternRequestMatcher.withDefaults().matcher((String)configValue.unwrapped()));
            }
        } else {
            list.add(PathPatternRequestMatcher.withDefaults().matcher("/"));
        }
        this.orMatcher = new OrRequestMatcher(list);
    }

    public boolean matches(HttpServletRequest request) {
        return this.orMatcher.matches(request);
    }
}

