/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.rest;

import com.erudika.para.core.App;
import com.erudika.para.core.ParaObject;
import com.erudika.para.core.User;
import com.erudika.para.core.Votable;
import com.erudika.para.core.annotations.Locked;
import com.erudika.para.core.metrics.Metrics;
import com.erudika.para.core.rest.GenericExceptionMapper;
import com.erudika.para.core.utils.CoreUtils;
import com.erudika.para.core.utils.Pager;
import com.erudika.para.core.utils.Para;
import com.erudika.para.core.utils.ParaObjectUtils;
import com.erudika.para.core.utils.Utils;
import com.erudika.para.core.validation.ValidationUtils;
import com.erudika.para.server.security.SecurityUtils;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RestUtils {
    private static final Logger logger = LoggerFactory.getLogger(RestUtils.class);

    private RestUtils() {
    }

    public static String extractAccessKey(HttpServletRequest request) {
        if (request == null) {
            return "";
        }
        String accessKey = "";
        String auth = request.getHeader("Authorization");
        boolean isAnonymousRequest = RestUtils.isAnonymousRequest(request);
        if (StringUtils.isBlank((CharSequence)auth)) {
            auth = request.getParameter("X-Amz-Credential");
            if (!StringUtils.isBlank((CharSequence)auth)) {
                accessKey = StringUtils.substringBetween((String)auth, (String)"=", (String)"/");
            }
        } else {
            accessKey = isAnonymousRequest ? StringUtils.substringAfter((String)auth, (String)"Anonymous").trim() : StringUtils.substringBetween((String)auth, (String)"=", (String)"/");
        }
        if (isAnonymousRequest && StringUtils.isBlank((CharSequence)accessKey)) {
            accessKey = request.getParameter("accessKey");
        }
        return accessKey;
    }

    public static boolean isAnonymousRequest(HttpServletRequest request) {
        return request != null && (StringUtils.startsWith((CharSequence)request.getHeader("Authorization"), (CharSequence)"Anonymous") || StringUtils.isBlank((CharSequence)request.getHeader("Authorization")));
    }

    public static String extractDate(HttpServletRequest request) {
        if (request == null) {
            return "";
        }
        String date = request.getHeader("X-Amz-Date");
        if (StringUtils.isBlank((CharSequence)date)) {
            return request.getParameter("X-Amz-Date");
        }
        return date;
    }

    public static String extractResourcePath(HttpServletRequest request) {
        if (request == null || request.getRequestURI().length() <= 3) {
            return "";
        }
        String uri = request.getRequestURI().substring(1);
        int start = uri.indexOf(47);
        if (start >= 0 && start + 1 < uri.length()) {
            return uri.substring(start + 1);
        }
        return "";
    }

    public static ParaObject readResourcePath(String appid, String path) {
        if (StringUtils.isBlank((CharSequence)appid) || StringUtils.isBlank((CharSequence)path) || !path.contains("/")) {
            return null;
        }
        try {
            URI uri = new URI(path);
            if (path.length() > 1) {
                String id;
                String[] parts = (path = path.startsWith("/") ? uri.getPath().substring(1) : uri.getPath()).split("/");
                if (parts.length == 1) {
                    id = parts[0];
                } else if (parts.length >= 2) {
                    id = parts[1];
                } else {
                    return null;
                }
                return Para.getDAO().read(appid, id);
            }
        }
        catch (Exception e) {
            logger.debug("Invalid resource path {}:", (Object)path, (Object)e);
        }
        return null;
    }

    public static Response getEntity(InputStream is, Class<?> type) {
        return RestUtils.getEntity(is, type, false);
    }

    public static Response getEntity(InputStream is, Class<?> type, boolean batchMode) {
        Object entity;
        block14: {
            try {
                if (is != null) {
                    int maxReqSize = Para.getConfig().maxEntitySizeBytes();
                    int maxReqSizeKb = maxReqSize / 1024;
                    if (!batchMode && is.available() > maxReqSize) {
                        return RestUtils.getStatusResponse(Response.Status.BAD_REQUEST, "Request is too large - the maximum is " + maxReqSizeKb + " KB.");
                    }
                    if (batchMode && is.available() > 100 * maxReqSize) {
                        return RestUtils.getStatusResponse(Response.Status.BAD_REQUEST, "Batch request is too large - the maximum total batch size is " + 100 * maxReqSizeKb + " KB.");
                    }
                    if (type == null) {
                        entity = is;
                    } else if (batchMode && is.available() > maxReqSize) {
                        JsonNode entityNode = ParaObjectUtils.getJsonReader(type).readTree(is);
                        boolean tooLarge = false;
                        if (entityNode.isArray()) {
                            for (JsonNode i : entityNode) {
                                if (RestUtils.calculateObjectSize(i) <= maxReqSize) continue;
                                tooLarge = true;
                                break;
                            }
                        }
                        if (tooLarge) {
                            return RestUtils.getStatusResponse(Response.Status.BAD_REQUEST, "Batch request too large or containing items larger than the max. allowed size " + maxReqSizeKb + " KB.");
                        }
                        entity = ParaObjectUtils.getJsonReader(type).readValue(entityNode);
                    } else {
                        entity = ParaObjectUtils.getJsonReader(type).readValue(is);
                    }
                    break block14;
                }
                return RestUtils.getStatusResponse(Response.Status.BAD_REQUEST, "Missing request body.");
            }
            catch (JsonMappingException e) {
                return RestUtils.getStatusResponse(Response.Status.BAD_REQUEST, e.getMessage());
            }
            catch (JsonParseException e) {
                return RestUtils.getStatusResponse(Response.Status.BAD_REQUEST, e.getMessage());
            }
            catch (IOException e) {
                logger.error(null, (Throwable)e);
                return RestUtils.getStatusResponse(Response.Status.INTERNAL_SERVER_ERROR, e.toString());
            }
        }
        return Response.ok((Object)entity).build();
    }

    public static Response getVotingResponse(ParaObject object, Map<String, Object> entity) {
        boolean voteSuccess = false;
        if (object != null && entity != null) {
            String upvoterId = (String)entity.get("_voteup");
            String downvoterId = (String)entity.get("_votedown");
            Integer lockAfter = (Integer)entity.get("_vote_locked_after");
            Integer expiresAfter = (Integer)entity.get("_vote_expires_after");
            if (!StringUtils.isBlank((CharSequence)upvoterId)) {
                voteSuccess = lockAfter == null && expiresAfter == null ? object.voteUp(upvoterId) : CoreUtils.getInstance().vote(object, upvoterId, Votable.VoteValue.UP, expiresAfter, lockAfter);
            } else if (!StringUtils.isBlank((CharSequence)downvoterId)) {
                voteSuccess = lockAfter == null && expiresAfter == null ? object.voteDown(downvoterId) : CoreUtils.getInstance().vote(object, downvoterId, Votable.VoteValue.DOWN, expiresAfter, lockAfter);
            }
            if (voteSuccess) {
                object.update();
            }
        }
        return Response.ok((Object)voteSuccess).build();
    }

    public static Response getReadResponse(App app, ParaObject content) {
        try (Metrics.Context context = Metrics.time((String)(app == null ? null : app.getAppid()), RestUtils.class, (String[])new String[]{"crud", "read"});){
            if (app != null && content != null && SecurityUtils.checkImplicitAppPermissions(app, content) && SecurityUtils.checkIfUserCanModifyObject(app, content)) {
                Response response = Response.ok((Object)content).build();
                return response;
            }
            Response response = RestUtils.getStatusResponse(Response.Status.NOT_FOUND, new String[0]);
            return response;
        }
    }

    public static Response getCreateResponse(App app, String type, InputStream is) {
        try (Metrics.Context context = Metrics.time((String)(app == null ? null : app.getAppid()), RestUtils.class, (String[])new String[]{"crud", "create"});){
            Response entityRes = RestUtils.getEntity(is, Map.class);
            if (entityRes.getStatusInfo() == Response.Status.OK) {
                Map newContent = (Map)entityRes.getEntity();
                String declaredType = (String)newContent.get("type");
                if (!(StringUtils.isBlank((CharSequence)type) || !StringUtils.isBlank((CharSequence)declaredType) && type.startsWith(declaredType))) {
                    newContent.put("type", type);
                }
                ParaObject content = ParaObjectUtils.setAnnotatedFields((Map)newContent);
                if (app != null && content != null && SecurityUtils.isNotAnApp(type)) {
                    String id;
                    content.setAppid(app.getAppIdentifier());
                    RestUtils.setCreatorid(app, content);
                    String[] errors = ValidationUtils.validateObject((App)app, (ParaObject)content);
                    if (errors.length == 0 && (id = content.create()) != null) {
                        if (app.addDatatypes(new ParaObject[]{content})) {
                            CoreUtils.getInstance().overwrite((ParaObject)app);
                        }
                        Response response = Response.created((URI)URI.create(Utils.urlEncode((String)content.getObjectURI()))).entity((Object)content).build();
                        return response;
                    }
                    Response response = RestUtils.getStatusResponse(Response.Status.BAD_REQUEST, errors);
                    return response;
                }
                Response response = RestUtils.getStatusResponse(Response.Status.BAD_REQUEST, "Failed to create object.");
                return response;
            }
            Response response = entityRes;
            return response;
        }
    }

    public static Response getOverwriteResponse(App app, String id, String type, InputStream is) {
        try (Metrics.Context context = Metrics.time((String)(app == null ? null : app.getAppid()), RestUtils.class, (String[])new String[]{"crud", "overwrite"});){
            Response entityRes = RestUtils.getEntity(is, Map.class);
            if (entityRes.getStatusInfo() == Response.Status.OK) {
                Map newContent = (Map)entityRes.getEntity();
                if (!StringUtils.isBlank((CharSequence)type)) {
                    newContent.put("type", type);
                }
                ParaObject content = ParaObjectUtils.setAnnotatedFields((Map)newContent);
                if (app != null && content != null && !StringUtils.isBlank((CharSequence)id) && SecurityUtils.isNotAnApp(type)) {
                    content.setType(type);
                    content.setAppid(app.getAppIdentifier());
                    content.setId(id);
                    RestUtils.setCreatorid(app, content);
                    String[] errors = ValidationUtils.validateObject((App)app, (ParaObject)content);
                    if (errors.length == 0 && SecurityUtils.checkIfUserCanModifyObject(app, content)) {
                        CoreUtils.getInstance().overwrite(app.getAppIdentifier(), content);
                        if (app.addDatatypes(new ParaObject[]{content})) {
                            CoreUtils.getInstance().overwrite((ParaObject)app);
                        }
                        Response response = Response.ok((Object)content).build();
                        return response;
                    }
                    Response response = RestUtils.getStatusResponse(Response.Status.BAD_REQUEST, errors);
                    return response;
                }
                Response response = RestUtils.getStatusResponse(Response.Status.BAD_REQUEST, "Failed to overwrite object.");
                return response;
            }
            Response response = entityRes;
            return response;
        }
    }

    public static Response getUpdateResponse(App app, ParaObject object, InputStream is) {
        try (Metrics.Context context = Metrics.time((String)(app == null ? null : app.getAppid()), RestUtils.class, (String[])new String[]{"crud", "update"});){
            if (app != null && object != null) {
                Response entityRes = RestUtils.getEntity(is, Map.class);
                String[] errors = new String[]{};
                if (entityRes.getStatusInfo() != Response.Status.OK) {
                    Response response = entityRes;
                    return response;
                }
                Map newContent = (Map)entityRes.getEntity();
                object.setAppid(SecurityUtils.isNotAnApp(object.getType()) ? app.getAppIdentifier() : app.getAppid());
                if (newContent.containsKey("_voteup") || newContent.containsKey("_votedown")) {
                    Response response = RestUtils.getVotingResponse(object, newContent);
                    return response;
                }
                ParaObjectUtils.setAnnotatedFields((ParaObject)object, (Map)newContent, Locked.class);
                if (SecurityUtils.checkImplicitAppPermissions(app, object) && (errors = ValidationUtils.validateObject((App)app, (ParaObject)object)).length == 0 && SecurityUtils.checkIfUserCanModifyObject(app, object)) {
                    object.update();
                    if (object.getVersion() == -1L) {
                        Response response = RestUtils.getStatusResponse(Response.Status.PRECONDITION_FAILED, "Update failed due to 'version' mismatch.");
                        return response;
                    }
                    if (app.addDatatypes(new ParaObject[]{object})) {
                        CoreUtils.getInstance().overwrite((ParaObject)app);
                    }
                    Response response = Response.ok((Object)object).build();
                    return response;
                }
                Response response = RestUtils.getStatusResponse(Response.Status.BAD_REQUEST, errors);
                return response;
            }
            Response response = RestUtils.getStatusResponse(Response.Status.NOT_FOUND, new String[0]);
            return response;
        }
    }

    public static Response getDeleteResponse(App app, ParaObject content) {
        try (Metrics.Context context = Metrics.time((String)(app == null ? null : app.getAppid()), RestUtils.class, (String[])new String[]{"crud", "delete"});){
            if (app != null && content != null && content.getId() != null && content.getAppid() != null) {
                if (SecurityUtils.checkImplicitAppPermissions(app, content) && SecurityUtils.checkIfUserCanModifyObject(app, content)) {
                    content.setAppid(SecurityUtils.isNotAnApp(content.getType()) ? app.getAppIdentifier() : app.getAppid());
                    content.delete();
                    Response response = Response.ok().build();
                    return response;
                }
                Response response = RestUtils.getStatusResponse(Response.Status.BAD_REQUEST, new String[0]);
                return response;
            }
            Response response = RestUtils.getStatusResponse(Response.Status.NOT_FOUND, new String[0]);
            return response;
        }
    }

    public static Response getBatchReadResponse(App app, List<String> ids) {
        try (Metrics.Context context = Metrics.time((String)(app == null ? null : app.getAppid()), RestUtils.class, (String[])new String[]{"batch", "read"});){
            if (app != null && ids != null && !ids.isEmpty()) {
                ArrayList<ParaObject> results = new ArrayList<ParaObject>(ids.size());
                for (ParaObject result : Para.getDAO().readAll(app.getAppIdentifier(), ids, true).values()) {
                    if (!SecurityUtils.checkImplicitAppPermissions(app, result) || !SecurityUtils.checkIfUserCanModifyObject(app, result)) continue;
                    results.add(result);
                }
                Response response = Response.ok(results).build();
                return response;
            }
            Response response = RestUtils.getStatusResponse(Response.Status.BAD_REQUEST, "Missing ids.");
            return response;
        }
    }

    public static Response getBatchCreateResponse(App app, InputStream is) {
        try (Metrics.Context context = Metrics.time((String)(app == null ? null : app.getAppid()), RestUtils.class, (String[])new String[]{"batch", "create"});){
            if (app != null) {
                LinkedList<ParaObject> newObjects = new LinkedList<ParaObject>();
                LinkedHashSet<String> ids = new LinkedHashSet<String>();
                Response entityRes = RestUtils.getEntity(is, List.class, true);
                if (entityRes.getStatusInfo() == Response.Status.OK) {
                    List items = (List)entityRes.getEntity();
                    for (Map object : items) {
                        ParaObject pobj;
                        String type = (String)object.get("type");
                        if (!SecurityUtils.isNotAnApp(type) || (pobj = ParaObjectUtils.setAnnotatedFields((Map)object)) == null || !ValidationUtils.isValidObject((App)app, (ParaObject)pobj)) continue;
                        pobj.setAppid(app.getAppIdentifier());
                        RestUtils.setCreatorid(app, pobj);
                        if (pobj.getId() != null && ids.contains(pobj.getId())) {
                            logger.warn("Batch contains objects with duplicate ids. Duplicate object {} might not be persisted!", (Object)pobj.getId());
                        }
                        ids.add(pobj.getId());
                        newObjects.add(pobj);
                    }
                } else {
                    Response response = entityRes;
                    return response;
                }
                Para.getDAO().createAll(app.getAppIdentifier(), newObjects);
                Para.asyncExecute(() -> {
                    if (app.addDatatypes(newObjects.toArray(new ParaObject[0]))) {
                        CoreUtils.getInstance().overwrite((ParaObject)app);
                    }
                });
                Response response = Response.ok(newObjects).build();
                return response;
            }
            Response response = RestUtils.getStatusResponse(Response.Status.BAD_REQUEST, new String[0]);
            return response;
        }
    }

    public static Response getBatchUpdateResponse(App app, Map<String, ParaObject> oldObjects, List<Map<String, Object>> newProperties) {
        try (Metrics.Context context = Metrics.time((String)(app == null ? null : app.getAppid()), RestUtils.class, (String[])new String[]{"batch", "update"});){
            if (app != null && oldObjects != null && newProperties != null) {
                LinkedList<ParaObject> updatedObjects = new LinkedList<ParaObject>();
                boolean hasPositiveVersions = false;
                for (Map<String, Object> newProps : newProperties) {
                    ParaObject updatedObject;
                    ParaObject oldObject;
                    if (newProps == null || !newProps.containsKey("id") || (oldObject = oldObjects.get((String)newProps.get("id"))) == null || !SecurityUtils.checkImplicitAppPermissions(app, oldObject) || !ValidationUtils.isValidObject((App)app, (ParaObject)(updatedObject = ParaObjectUtils.setAnnotatedFields((ParaObject)oldObject, newProps, Locked.class))) || !SecurityUtils.checkIfUserCanModifyObject(app, updatedObject)) continue;
                    updatedObject.setAppid(app.getAppIdentifier());
                    updatedObjects.add(updatedObject);
                    if (updatedObject.getVersion() == null || updatedObject.getVersion() <= 0L) continue;
                    hasPositiveVersions = true;
                }
                Para.getDAO().updateAll(app.getAppIdentifier(), updatedObjects);
                Response response = RestUtils.handleFailedUpdates(hasPositiveVersions, updatedObjects);
                return response;
            }
            Response response = RestUtils.getStatusResponse(Response.Status.BAD_REQUEST, new String[0]);
            return response;
        }
    }

    public static Response getBatchDeleteResponse(App app, List<String> ids) {
        try (Metrics.Context context = Metrics.time((String)(app == null ? null : app.getAppid()), RestUtils.class, (String[])new String[]{"batch", "delete"});){
            LinkedList<ParaObject> objects = new LinkedList<ParaObject>();
            if (app != null && ids != null && !ids.isEmpty()) {
                for (ParaObject pobj : Para.getDAO().readAll(app.getAppIdentifier(), ids, true).values()) {
                    if (pobj == null || pobj.getId() == null || pobj.getType() == null || !SecurityUtils.isNotAnApp(pobj.getType()) || !SecurityUtils.checkIfUserCanModifyObject(app, pobj)) continue;
                    objects.add(pobj);
                }
            } else {
                Response response = RestUtils.getStatusResponse(Response.Status.BAD_REQUEST, "Missing ids.");
                return response;
            }
            Para.getDAO().deleteAll(app.getAppIdentifier(), objects);
            Response response = Response.ok().build();
            return response;
        }
    }

    public static Response readLinksHandler(ParaObject pobj, String id2, String type2, MultivaluedMap<String, String> params, Pager pager, boolean childrenOnly) {
        try (Metrics.Context context = Metrics.time(null, RestUtils.class, (String[])new String[]{"links", "read"});){
            String query = (String)params.getFirst((Object)"q");
            if (type2 != null) {
                if (id2 != null) {
                    Response response = Response.ok((Object)pobj.isLinked(type2, id2), (MediaType)MediaType.TEXT_PLAIN_TYPE).build();
                    return response;
                }
                List items = new ArrayList();
                if (childrenOnly) {
                    if (params.containsKey((Object)"count")) {
                        pager.setCount(pobj.countChildren(type2).longValue());
                    } else {
                        items = params.containsKey((Object)"field") && params.containsKey((Object)"term") ? pobj.getChildren(type2, (String)params.getFirst((Object)"field"), (String)params.getFirst((Object)"term"), new Pager[]{pager}) : (StringUtils.isBlank((CharSequence)query) ? pobj.getChildren(type2, new Pager[]{pager}) : pobj.findChildren(type2, query, new Pager[]{pager}));
                    }
                } else if (params.containsKey((Object)"count")) {
                    pager.setCount(pobj.countLinks(type2).longValue());
                } else {
                    items = StringUtils.isBlank((CharSequence)query) ? pobj.getLinkedObjects(type2, new Pager[]{pager}) : pobj.findLinkedObjects(type2, (String)params.getFirst((Object)"field"), query, new Pager[]{pager});
                }
                Response response = Response.ok(RestUtils.buildPageResponse(items, pager)).build();
                return response;
            }
            Response response = RestUtils.getStatusResponse(Response.Status.BAD_REQUEST, "Parameter 'type' is missing.");
            return response;
        }
    }

    public static Response deleteLinksHandler(ParaObject pobj, String id2, String type2, boolean childrenOnly) {
        try (Metrics.Context context = Metrics.time(null, RestUtils.class, (String[])new String[]{"links", "delete"});){
            if (type2 == null && id2 == null) {
                pobj.unlinkAll();
            } else if (type2 != null) {
                if (id2 != null) {
                    pobj.unlink(type2, id2);
                } else if (childrenOnly) {
                    pobj.deleteChildren(type2);
                }
            }
            Response response = Response.ok().build();
            return response;
        }
    }

    public static Response createLinksHandler(ParaObject pobj, String id2) {
        try (Metrics.Context context = Metrics.time(null, RestUtils.class, (String[])new String[]{"links", "create"});){
            if (id2 != null && pobj != null) {
                String linkid = pobj.link(id2);
                if (linkid == null) {
                    Response response = RestUtils.getStatusResponse(Response.Status.BAD_REQUEST, "Failed to create link.");
                    return response;
                }
                Response response = Response.ok((Object)linkid, (MediaType)MediaType.TEXT_PLAIN_TYPE).build();
                return response;
            }
            Response response = RestUtils.getStatusResponse(Response.Status.BAD_REQUEST, "Parameters 'type' and 'id' are missing.");
            return response;
        }
    }

    static <P extends ParaObject> Map<String, Object> buildQueryAndSearch(App app, String querytype, MultivaluedMap<String, String> params, String typeOverride) {
        String query = RestUtils.paramOrDefault(params, "q", "*");
        String appid = app.getAppIdentifier();
        Pager pager = RestUtils.getPagerFromParams(params);
        List items = Collections.emptyList();
        String queryType = RestUtils.paramOrDefault(params, "querytype", querytype);
        String type = RestUtils.paramOrDefault(params, "type", null);
        if (!StringUtils.isBlank((CharSequence)typeOverride) && !"search".equals(typeOverride)) {
            type = typeOverride;
        }
        try (Metrics.Context context = Metrics.time((String)appid, RestUtils.class, (String[])new String[]{"search", queryType});){
            if (params == null) {
                Map<String, Object> map = RestUtils.buildPageResponse(Para.getSearch().findQuery(appid, type, query, new Pager[]{pager}), pager);
                return map;
            }
            if ("id".equals(queryType)) {
                items = RestUtils.findByIdQuery(params, appid, pager);
            } else if ("ids".equals(queryType)) {
                items = Para.getSearch().findByIds(appid, (List)params.get((Object)"ids"));
                pager.setCount((long)items.size());
            } else if ("nested".equals(queryType)) {
                items = Para.getSearch().findNestedQuery(appid, type, (String)params.getFirst((Object)"field"), query, new Pager[]{pager});
            } else if ("nearby".equals(queryType)) {
                items = RestUtils.findNearbyQuery(params, appid, type, query, pager);
            } else if ("prefix".equals(queryType)) {
                items = Para.getSearch().findPrefix(appid, type, (String)params.getFirst((Object)"field"), (String)params.getFirst((Object)"prefix"), new Pager[]{pager});
            } else if ("similar".equals(queryType)) {
                items = RestUtils.findSimilarQuery(params, appid, type, pager);
            } else if ("tagged".equals(queryType)) {
                items = RestUtils.findTaggedQuery(params, appid, type, pager);
            } else if ("in".equals(queryType)) {
                items = Para.getSearch().findTermInList(appid, type, (String)params.getFirst((Object)"field"), (List)params.get((Object)"terms"), new Pager[]{pager});
            } else if ("terms".equals(queryType)) {
                items = RestUtils.findTermsQuery(params, pager, appid, type);
            } else if ("wildcard".equals(queryType)) {
                items = Para.getSearch().findWildcard(appid, type, (String)params.getFirst((Object)"field"), query, new Pager[]{pager});
            } else if ("count".equals(queryType)) {
                pager.setCount(Para.getSearch().getCount(appid, type).longValue());
            } else {
                items = Para.getSearch().findQuery(appid, type, query, new Pager[]{pager});
            }
            Map<String, Object> map = RestUtils.buildPageResponse(items, pager);
            return map;
        }
    }

    private static <P extends ParaObject> List<P> findTermsQuery(MultivaluedMap<String, String> params, Pager pager, String appid, String type) {
        if (params == null) {
            return Collections.emptyList();
        }
        String matchAll = RestUtils.paramOrDefault(params, "matchall", "true");
        List termsList = (List)params.get((Object)"terms");
        if (termsList != null) {
            HashMap<String, String> terms = new HashMap<String, String>(termsList.size());
            for (String termTuple : termsList) {
                if (StringUtils.isBlank((CharSequence)termTuple) || !termTuple.contains(Para.getConfig().separator())) continue;
                String[] split = termTuple.split(Para.getConfig().separator(), 2);
                terms.put(split[0], split[1]);
            }
            if (params.containsKey((Object)"count")) {
                pager.setCount(Para.getSearch().getCount(appid, type, terms).longValue());
            } else {
                return Para.getSearch().findTerms(appid, type, terms, Boolean.parseBoolean(matchAll), new Pager[]{pager});
            }
        }
        return Collections.emptyList();
    }

    private static <P extends ParaObject> List<P> findTaggedQuery(MultivaluedMap<String, String> params, String appid, String type, Pager pager) {
        List tags = (List)params.get((Object)"tags");
        String[] tagz = tags != null ? tags.toArray(new String[0]) : null;
        return Para.getSearch().findTagged(appid, type, tagz, new Pager[]{pager});
    }

    private static <P extends ParaObject> List<P> findSimilarQuery(MultivaluedMap<String, String> params, String appid, String type, Pager pager) {
        ParaObject likeObj;
        String[] fieldz;
        List fields = (List)params.get((Object)"fields");
        String like = (String)params.getFirst((Object)"like");
        String[] stringArray = fieldz = fields != null ? fields.toArray(new String[0]) : null;
        if (StringUtils.startsWith((CharSequence)like, (CharSequence)"id:") && (likeObj = Para.getDAO().read(appid, StringUtils.removeStart((String)like, (String)"id:"))) != null) {
            StringBuilder sb = new StringBuilder();
            Arrays.asList(fieldz).forEach(field -> {
                try {
                    String value = BeanUtils.getProperty((Object)likeObj, (String)field);
                    if (value != null) {
                        sb.append(Utils.stripAndTrim((String)value)).append(" ");
                    }
                }
                catch (Exception e) {
                    logger.debug("Missing fields {} in object {}: {}", new Object[]{fields, likeObj.getId(), e.getMessage()});
                }
            });
            like = sb.toString();
        }
        return Para.getSearch().findSimilar(appid, type, (String)params.getFirst((Object)"filterid"), fieldz, like, new Pager[]{pager});
    }

    private static <P extends ParaObject> List<P> findNearbyQuery(MultivaluedMap<String, String> params, String appid, String type, String query, Pager pager) {
        String latlng = (String)params.getFirst((Object)"latlng");
        if (StringUtils.contains((CharSequence)latlng, (CharSequence)",")) {
            String[] coords = latlng.split(",", 2);
            String rad = RestUtils.paramOrDefault(params, "radius", null);
            int radius = NumberUtils.toInt((String)rad, (int)10);
            double lat = NumberUtils.toDouble((String)coords[0], (double)0.0);
            double lng = NumberUtils.toDouble((String)coords[1], (double)0.0);
            return Para.getSearch().findNearby(appid, type, query, radius, lat, lng, new Pager[]{pager});
        }
        return Collections.emptyList();
    }

    private static <P extends ParaObject> List<P> findByIdQuery(MultivaluedMap<String, String> params, String appid, Pager pager) {
        String id = RestUtils.paramOrDefault(params, "id", null);
        ParaObject obj = Para.getSearch().findById(appid, id);
        if (obj != null) {
            pager.setCount(1L);
            return Collections.singletonList(obj);
        }
        return Collections.emptyList();
    }

    private static Response handleFailedUpdates(boolean precondition, List<ParaObject> updatedObjects) {
        if (precondition) {
            boolean wasNotEmpty = !updatedObjects.isEmpty();
            Iterator<ParaObject> it = updatedObjects.iterator();
            while (it.hasNext()) {
                ParaObject updatedObject = it.next();
                if (updatedObject.getVersion() != -1L) continue;
                it.remove();
            }
            if (wasNotEmpty && updatedObjects.isEmpty()) {
                return RestUtils.getStatusResponse(Response.Status.PRECONDITION_FAILED, "Update failed for all objects in batch due to 'version' mismatch.");
            }
        }
        return Response.ok(updatedObjects).build();
    }

    private static String paramOrDefault(MultivaluedMap<String, String> params, String name, String defaultValue) {
        return params != null && params.containsKey((Object)name) ? (String)params.getFirst((Object)name) : defaultValue;
    }

    private static <P extends ParaObject> Map<String, Object> buildPageResponse(List<P> items, Pager pager) {
        App app = SecurityUtils.getPrincipalApp();
        ArrayList<ParaObject> checkedItems = new ArrayList<ParaObject>(items.size());
        for (ParaObject item : items) {
            if (!SecurityUtils.checkImplicitAppPermissions(app, item) || !SecurityUtils.checkIfUserCanModifyObject(app, item)) continue;
            checkedItems.add(item);
        }
        if (!items.isEmpty() && checkedItems.isEmpty()) {
            pager.setCount(0L);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("items", checkedItems);
        result.put("page", pager.getPage());
        result.put("totalHits", pager.getCount());
        if (!StringUtils.isBlank((CharSequence)pager.getLastKey())) {
            result.put("lastKey", pager.getLastKey());
        }
        return result;
    }

    private static void setCreatorid(App app, ParaObject content) {
        User user;
        if (content != null && (user = SecurityUtils.getAuthenticatedUser()) != null) {
            content.setCreatorid(user.getId());
            if (!StringUtils.isBlank((CharSequence)content.getId()) && content.getCreatorid() != null && app.permissionsContainOwnKeyword(user, content) && !content.getId().startsWith(content.getCreatorid() + "_")) {
                content.setId(content.getCreatorid() + "_" + content.getId());
            }
        }
    }

    private static int calculateObjectSize(JsonNode jsonNode) {
        if (jsonNode == null || jsonNode.isNull()) {
            return 4;
        }
        if (jsonNode.isTextual() || jsonNode.isNumber() || jsonNode.isBoolean()) {
            return 2 + jsonNode.asText().length();
        }
        if (jsonNode.isArray() || jsonNode.isObject()) {
            AtomicInteger size = new AtomicInteger(2);
            if (jsonNode.isObject()) {
                jsonNode.fieldNames().forEachRemaining(field -> size.getAndAdd(12 + field.length()));
            }
            if (!jsonNode.isEmpty()) {
                size.getAndAdd(jsonNode.size() - 1);
                jsonNode.elements().forEachRemaining(element -> size.getAndAdd(RestUtils.calculateObjectSize(element)));
            }
            return size.get();
        }
        return jsonNode.asText().length();
    }

    public static Pager getPagerFromParams(MultivaluedMap<String, String> params) {
        Pager pager = new Pager();
        pager.setPage(NumberUtils.toLong((String)RestUtils.paramOrDefault(params, "page", ""), (long)0L));
        if (pager.getPage() > (long)Para.getConfig().maxPages()) {
            pager.setPage((long)Para.getConfig().maxPages());
        }
        pager.setLimit(NumberUtils.toInt((String)RestUtils.paramOrDefault(params, "limit", ""), (int)pager.getLimit()));
        if (pager.getLimit() > Para.getConfig().maxPageLimit()) {
            pager.setLimit(Para.getConfig().maxPageLimit());
        }
        pager.setSortby(RestUtils.paramOrDefault(params, "sort", pager.getSortby()));
        pager.setDesc(Boolean.parseBoolean(RestUtils.paramOrDefault(params, "desc", "true")));
        pager.setLastKey(RestUtils.paramOrDefault(params, "lastKey", null));
        return pager;
    }

    public static Response getStatusResponse(Response.Status status, String ... messages) {
        if (status == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        String msg = StringUtils.join((Object[])messages, (String)". ");
        if (StringUtils.isBlank((CharSequence)msg)) {
            msg = status.getReasonPhrase();
        }
        try {
            return GenericExceptionMapper.getExceptionResponse((int)status.getStatusCode(), (String)msg);
        }
        catch (Exception ex) {
            logger.error(null, (Throwable)ex);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    public static void returnStatusResponse(HttpServletResponse response, int status, String message) {
        if (response == null) {
            return;
        }
        try (ServletOutputStream out = response.getOutputStream();){
            response.setStatus(status);
            response.setContentType("application/json");
            response.setCharacterEncoding(Para.getConfig().defaultEncoding());
            ParaObjectUtils.getJsonWriter().writeValue((OutputStream)out, RestUtils.getStatusResponse(Response.Status.fromStatusCode((int)status), message).getEntity());
        }
        catch (Exception ex) {
            logger.error(null, (Throwable)ex);
        }
    }

    public static void returnObjectResponse(HttpServletResponse response, Object obj) {
        if (response == null) {
            return;
        }
        try (ServletOutputStream out = response.getOutputStream();){
            response.setStatus(200);
            response.setContentType("application/json");
            response.setCharacterEncoding(Para.getConfig().defaultEncoding());
            ParaObjectUtils.getJsonWriter().writeValue((OutputStream)out, obj);
        }
        catch (Exception ex) {
            logger.error(null, (Throwable)ex);
        }
    }

    public static String pathParam(String param, ContainerRequestContext ctx) {
        return (String)ctx.getUriInfo().getPathParameters().getFirst((Object)param);
    }

    public static List<String> pathParams(String param, ContainerRequestContext ctx) {
        return (List)ctx.getUriInfo().getPathParameters().get((Object)param);
    }

    public static String queryParam(String param, ContainerRequestContext ctx) {
        return (String)ctx.getUriInfo().getQueryParameters().getFirst((Object)param);
    }

    public static List<String> queryParams(String param, ContainerRequestContext ctx) {
        return (List)ctx.getUriInfo().getQueryParameters().get((Object)param);
    }

    public static boolean hasQueryParam(String param, ContainerRequestContext ctx) {
        return ctx.getUriInfo().getQueryParameters().containsKey((Object)param);
    }
}

