/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.queue;

import com.erudika.para.core.queue.Queue;
import com.erudika.para.core.utils.Para;
import com.erudika.para.server.queue.AWSQueueUtils;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@Singleton
public class AWSQueue
implements Queue {
    private String name;
    private String url;

    public AWSQueue() {
        this(Para.getConfig().defaultQueueName());
    }

    public AWSQueue(String name) {
        this.setName(name);
    }

    public void push(String msg) {
        AWSQueueUtils.pushMessages(this.getUrl(), Collections.singletonList(msg));
    }

    public String pull() {
        List<String> msgs = AWSQueueUtils.pullMessages(this.getUrl(), 1);
        return msgs.isEmpty() ? "" : msgs.get(0);
    }

    public void startPolling() {
        AWSQueueUtils.startPollingForMessages(this.getUrl());
    }

    public void stopPolling() {
        AWSQueueUtils.stopPollingForMessages(this.getUrl());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        if (StringUtils.isBlank((CharSequence)this.url) && !StringUtils.isBlank((CharSequence)this.name)) {
            this.url = AWSQueueUtils.createQueue(this.name);
        }
        return this.url;
    }
}

