/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.email;

import com.erudika.para.core.email.Emailer;
import com.erudika.para.core.utils.Para;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.inject.Singleton;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.InternetHeaders;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ses.SesClient;
import software.amazon.awssdk.services.ses.SesClientBuilder;
import software.amazon.awssdk.services.ses.model.Body;
import software.amazon.awssdk.services.ses.model.Content;
import software.amazon.awssdk.services.ses.model.Destination;
import software.amazon.awssdk.services.ses.model.Message;
import software.amazon.awssdk.services.ses.model.SendEmailRequest;
import software.amazon.awssdk.services.ses.model.SendRawEmailRequest;

@Singleton
public class AWSEmailer
implements Emailer {
    private final SesClient sesclient = (SesClient)((SesClientBuilder)SesClient.builder().region(Region.of((String)Para.getConfig().awsSesRegion()))).build();

    public boolean sendEmail(List<String> emails, String subject, String body) {
        if (emails != null && !emails.isEmpty() && !StringUtils.isBlank((CharSequence)body)) {
            final SendEmailRequest.Builder request = SendEmailRequest.builder();
            request.source(Para.getConfig().supportEmail()).build();
            Iterator<String> emailz = emails.iterator();
            Destination.Builder dest = Destination.builder();
            dest.toAddresses(new String[]{emailz.next()});
            while (emailz.hasNext()) {
                dest.bccAddresses(new String[]{emailz.next()});
            }
            request.destination((Destination)dest.build());
            Message.Builder msg = Message.builder();
            msg.subject((Content)Content.builder().data(subject).build());
            msg.body((Body)Body.builder().html((Content)Content.builder().data(body).charset(Para.getConfig().defaultEncoding()).build()).build());
            request.message((Message)msg.build());
            Para.asyncExecute((Runnable)new Runnable(){
                final /* synthetic */ AWSEmailer this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.sesclient.sendEmail((SendEmailRequest)request.build());
                }
            });
            return true;
        }
        return false;
    }

    public boolean sendEmail(List<String> emails, String subject, String body, InputStream attachment, String mimeType, String fileName) {
        if (emails == null || emails.isEmpty() || StringUtils.isBlank((CharSequence)body)) {
            return false;
        }
        if (attachment == null || StringUtils.isBlank((CharSequence)mimeType)) {
            return this.sendEmail(emails, subject, body);
        }
        try {
            Session session = Session.getDefaultInstance((Properties)new Properties());
            MimeMessage message = new MimeMessage(session);
            message.setSubject(subject, "UTF-8");
            message.setFrom((Address)new InternetAddress(Para.getConfig().supportEmail()));
            Iterator<String> emailz = emails.iterator();
            message.setRecipients(MimeMessage.RecipientType.TO, (Address[])InternetAddress.parse((String)emailz.next()));
            StringBuilder sb = new StringBuilder();
            while (emailz.hasNext()) {
                sb.append(emailz.next()).append(emailz.hasNext() ? "," : "");
            }
            message.setRecipients(MimeMessage.RecipientType.BCC, (Address[])InternetAddress.parse((String)sb.toString()));
            MimeBodyPart htmlPart = new MimeBodyPart();
            htmlPart.setContent((Object)body, "text/html; charset=UTF-8");
            byte[] fileByteArray = IOUtils.toByteArray((InputStream)attachment);
            InternetHeaders fileHeaders = new InternetHeaders();
            fileHeaders.setHeader("Content-Type", mimeType + "; name=\"" + fileName + "\"");
            fileHeaders.setHeader("Content-Transfer-Encoding", "base64");
            fileHeaders.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
            MimeBodyPart attach = new MimeBodyPart(fileHeaders, fileByteArray);
            ByteArrayDataSource ds = new ByteArrayDataSource(fileByteArray, mimeType);
            attach.setDataHandler(new DataHandler((DataSource)ds));
            attach.setFileName(fileName);
            MimeMultipart msg = new MimeMultipart("mixed");
            msg.addBodyPart((BodyPart)htmlPart);
            msg.addBodyPart((BodyPart)attach);
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                message.setContent((Multipart)msg);
                message.writeTo((OutputStream)outputStream);
                SendRawEmailRequest rawEmailRequest = (SendRawEmailRequest)SendRawEmailRequest.builder().rawMessage(r -> r.data(SdkBytes.fromByteArray((byte[])outputStream.toByteArray()))).build();
                this.sesclient.sendRawEmail(rawEmailRequest);
            }
            return true;
        }
        catch (Exception ex) {
            LoggerFactory.getLogger(AWSEmailer.class).error(null, (Throwable)ex);
            return false;
        }
    }
}

