/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.aop;

import com.erudika.para.core.annotations.Measured;
import com.erudika.para.core.listeners.IOListener;
import com.erudika.para.core.metrics.Metrics;
import com.erudika.para.core.search.Search;
import com.erudika.para.core.utils.Para;
import com.erudika.para.server.aop.AOPUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Set;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchQueryAspect
implements MethodInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(SearchQueryAspect.class);

    public Object invoke(MethodInvocation mi) throws Throwable {
        if (!Modifier.isPublic(mi.getMethod().getModifiers())) {
            return mi.proceed();
        }
        Method searchMethod = mi.getMethod();
        Object[] args = mi.getArguments();
        String appid = AOPUtils.getFirstArgOfString(args);
        Method superMethod = null;
        Measured measuredAnno = null;
        try {
            superMethod = Search.class.getMethod(searchMethod.getName(), searchMethod.getParameterTypes());
            measuredAnno = superMethod.getAnnotation(Measured.class);
        }
        catch (Exception e) {
            logger.error("Error in search AOP layer!", (Throwable)e);
        }
        Set ioListeners = Para.getSearchQueryListeners();
        for (IOListener ioListener : ioListeners) {
            ioListener.onPreInvoke(superMethod, args);
            logger.debug("Executed {}.onPreInvoke().", (Object)ioListener.getClass().getName());
        }
        Object result = null;
        result = measuredAnno != null ? this.invokeTimedSearch(appid, searchMethod, mi) : mi.proceed();
        for (IOListener ioListener : ioListeners) {
            ioListener.onPostInvoke(superMethod, args, result);
            logger.debug("Executed {}.onPostInvoke().", (Object)ioListener.getClass().getName());
        }
        return result;
    }

    private Object invokeTimedSearch(String appid, Method searchMethod, MethodInvocation mi) throws Throwable {
        try (Metrics.Context context = Metrics.time((String)appid, searchMethod.getDeclaringClass(), (String[])new String[]{searchMethod.getName()});){
            Object object = mi.proceed();
            return object;
        }
    }
}

