/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.aop;

import com.erudika.para.core.ParaObject;
import com.erudika.para.core.Sysprop;
import com.erudika.para.core.utils.Utils;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class AOPUtils {
    private static final String SPECIAL_PREFIX = "_";

    private AOPUtils() {
    }

    protected static <T> List<T> getArgOfListOfType(Object[] args, Class<T> type) {
        if (args != null) {
            for (Object arg : args) {
                List list;
                if (arg == null || !(arg instanceof List) || (list = (List)arg).isEmpty()) continue;
                for (Object item : list) {
                    if (item == null || !type.isAssignableFrom(item.getClass())) continue;
                    return list;
                }
            }
        }
        return null;
    }

    protected static ParaObject getArgOfParaObject(Object[] args) {
        if (args != null) {
            for (Object arg : args) {
                if (arg == null || !(arg instanceof ParaObject)) continue;
                return (ParaObject)arg;
            }
        }
        return null;
    }

    protected static String getFirstArgOfString(Object[] args) {
        if (args != null) {
            for (Object arg : args) {
                if (arg == null || !(arg instanceof String)) continue;
                return (String)arg;
            }
        }
        return null;
    }

    protected static List<ParaObject> removeNotStoredNotIndexed(List<ParaObject> addUs, List<ParaObject> indexUs) {
        if (addUs != null) {
            LinkedList<ParaObject> removed = new LinkedList<ParaObject>();
            Iterator<ParaObject> it = addUs.iterator();
            while (it.hasNext()) {
                ParaObject obj = it.next();
                if (obj == null) continue;
                AOPUtils.checkAndFixType(obj);
                if (obj.getIndexed().booleanValue() && indexUs != null) {
                    indexUs.add(obj);
                }
                if (obj.getStored().booleanValue()) continue;
                removed.add(obj);
                it.remove();
            }
            return removed;
        }
        return Collections.emptyList();
    }

    protected static void checkAndFixType(ParaObject obj) {
        if (obj != null) {
            if (StringUtils.startsWith((CharSequence)obj.getType(), (CharSequence)SPECIAL_PREFIX)) {
                obj.setType(obj.getType().replaceAll("^[_]*", ""));
            }
            if (StringUtils.contains((CharSequence)obj.getType(), (CharSequence)"#")) {
                obj.setType(obj.getType().replaceAll("#", ""));
            }
            if (StringUtils.contains((CharSequence)obj.getType(), (CharSequence)"/")) {
                obj.setType(obj.getType().replaceAll("/", ""));
            }
            if (obj.getType().isEmpty()) {
                obj.setType(Utils.type(Sysprop.class));
            }
        }
    }
}

