/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.utils.filters;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class ErrorFilter
implements Filter {
    private static final String ERROR_MESSAGE = "javax.servlet.error.message";
    private static final String ERROR_STATUS_CODE = "javax.servlet.error.status_code";

    public void init(FilterConfig fc) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            ErrorWrapperResponse wrapped = new ErrorWrapperResponse((HttpServletResponse)response);
            try {
                chain.doFilter(request, (ServletResponse)wrapped);
                int status = wrapped.getStatus();
                if (status >= 400) {
                    this.setErrorAttributes(request, status, wrapped.getMessage());
                }
            }
            catch (Exception ex) {
                LoggerFactory.getLogger(this.getClass()).error(null, (Throwable)ex);
            }
            response.flushBuffer();
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    private void setErrorAttributes(ServletRequest request, int status, String message) {
        request.setAttribute(ERROR_STATUS_CODE, (Object)status);
        request.setAttribute(ERROR_MESSAGE, (Object)message);
    }

    private void rethrow(Throwable ex) throws IOException, ServletException {
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        if (ex instanceof IOException) {
            throw (IOException)ex;
        }
        if (ex instanceof ServletException) {
            throw (ServletException)ex;
        }
        throw new IllegalStateException(ex);
    }

    private static class ErrorWrapperResponse
    extends HttpServletResponseWrapper {
        private int status;
        private String message;

        ErrorWrapperResponse(HttpServletResponse response) {
            super(response);
        }

        public void sendError(int status) throws IOException {
            this.sendError(status, null);
        }

        public void sendError(int status, String message) throws IOException {
            this.status = status;
            this.message = message;
        }

        public int getStatus() {
            return this.status;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

