/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.utils;

import com.erudika.para.core.App;
import com.erudika.para.core.listeners.InitializeListener;
import com.erudika.para.core.utils.Para;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum HealthUtils implements InitializeListener,
Runnable
{
    INSTANCE{
        private boolean healthy = false;
        private boolean wasHealthy = false;
        private boolean rootAppExists = false;
        private ScheduledFuture<?> scheduledHealthCheck;
        private final List<String> failedServices = new ArrayList<String>(3);
        {
            App.addAppCreatedListener(app -> {
                if (app.isRootApp()) {
                    this.performHealthCheck();
                }
            });
        }

        @Override
        public boolean isHealthy() {
            return this.healthy;
        }

        @Override
        public synchronized void performHealthCheck() {
            String rootAppId = App.id((String)Para.getConfig().getRootAppIdentifier());
            if (!StringUtils.isBlank((CharSequence)rootAppId)) {
                this.healthy = true;
                this.failedServices.clear();
                if (!this.wasHealthy) {
                    Para.getCache().remove(rootAppId);
                }
                if (Para.getDAO() != null) {
                    boolean bl = this.rootAppExists = Para.getDAO().read(rootAppId) != null;
                    if (!this.rootAppExists) {
                        this.healthy = false;
                        this.failedServices.add("DAO");
                    }
                }
                if (this.healthy && Para.getConfig().isSearchEnabled() && Para.getSearch().findById(rootAppId) == null) {
                    this.healthy = false;
                    this.failedServices.add("Search");
                }
                if (this.healthy && Para.getConfig().isCacheEnabled()) {
                    String cacheTestId = UUID.randomUUID().toString();
                    Para.getCache().put(cacheTestId, (Object)"ok");
                    this.healthy = Para.getCache().contains(cacheTestId);
                    Para.getCache().remove(cacheTestId);
                    if (!this.healthy) {
                        this.failedServices.add("Cache");
                    }
                }
            }
            if (this.wasHealthy && !this.healthy) {
                logger.error("Server is no longer healthy! Health check failed for services: " + StringUtils.join(this.failedServices, (String)", "));
            }
            if (!this.wasHealthy && this.healthy) {
                logger.info("Server is healthy.");
            }
            this.wasHealthy = this.healthy;
        }

        public void onInitialize() {
            this.performHealthCheck();
            if (!this.isHealthy()) {
                if (this.rootAppExists) {
                    logger.warn("Server is unhealthy - the search index may be corrupted and may have to be rebuilt.");
                } else {
                    Map rootAppCredentials = Para.setup();
                    String confFile = Paths.get(Para.getConfig().getConfigFilePath(), new String[0]).toAbsolutePath().toString();
                    if (rootAppCredentials.containsKey("secretKey")) {
                        try (InputStream ref = this.getClass().getClassLoader().getResourceAsStream("reference.conf");
                             InputStream config = Optional.ofNullable(Para.getFileStore().load(confFile)).orElse(ref);){
                            Object confString = new String(config.readAllBytes(), StandardCharsets.UTF_8);
                            String accessKey = "para.root_access_key = \"" + (String)rootAppCredentials.get("accessKey") + "\"";
                            String secretKey = "para.root_secret_key = \"" + (String)rootAppCredentials.get("secretKey") + "\"";
                            confString = ((String)confString).contains("para.root_access_key") ? ((String)confString).replaceAll("para\\.root_access_key\\s*=\\s*\".*?\"", accessKey) : (String)confString + "\n" + accessKey;
                            confString = ((String)confString).contains("para.root_secret_key") ? ((String)confString).replaceAll("para\\.root_secret_key\\s*=\\s*\".*?\"", secretKey) : (String)confString + "\n" + secretKey;
                            Para.getFileStore().store(confFile, (InputStream)new ByteArrayInputStream(((String)confString).getBytes(StandardCharsets.UTF_8)));
                            logger.info("Saved root app credentials to {}.", (Object)confFile);
                        }
                        catch (Exception e) {
                            logger.info("Initialized root app with access key '{}' and secret '{}', but could not write these to {}.", new Object[]{rootAppCredentials.get("accessKey"), rootAppCredentials.get("secretKey"), confFile});
                        }
                    } else {
                        logger.warn("Server is unhealthy - failed to initialize root app. Open http://localhost:" + Para.getConfig().serverPort() + "/v1/_setup in the browser to initialize Para manually.");
                    }
                }
            }
            if (Para.getConfig().healthCheckEnabled() && this.scheduledHealthCheck == null) {
                this.scheduledHealthCheck = Para.getScheduledExecutorService().scheduleAtFixedRate(this, 30L, Para.getConfig().healthCheckInvervalSec(), TimeUnit.SECONDS);
            }
        }

        @Override
        public void run() {
            this.performHealthCheck();
        }
    };

    private static final Logger logger;

    public static HealthUtils getInstance() {
        return INSTANCE;
    }

    public abstract boolean isHealthy();

    public abstract void performHealthCheck();

    static {
        logger = LoggerFactory.getLogger(HealthUtils.class);
    }
}

