/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.utils;

import com.erudika.para.server.utils.GZipServletOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class GZipServletResponseWrapper
extends HttpServletResponseWrapper {
    private GZipServletOutputStream gzipOutputStream = null;
    private PrintWriter printWriter = null;
    private boolean disableFlushBuffer = false;

    public GZipServletResponseWrapper(HttpServletResponse response, GZIPOutputStream gzout) throws IOException {
        super(response);
        this.gzipOutputStream = new GZipServletOutputStream(gzout);
    }

    public void close() throws IOException {
        if (this.printWriter != null) {
            this.printWriter.close();
        }
        if (this.gzipOutputStream != null) {
            this.gzipOutputStream.close();
        }
    }

    public void flushBuffer() throws IOException {
        if (this.printWriter != null) {
            this.printWriter.flush();
        }
        if (this.gzipOutputStream != null) {
            this.gzipOutputStream.flush();
        }
        if (!this.disableFlushBuffer) {
            super.flushBuffer();
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.printWriter != null) {
            throw new IllegalStateException("PrintWriter obtained already - cannot get OutputStream");
        }
        return this.gzipOutputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.printWriter == null) {
            this.gzipOutputStream = new GZipServletOutputStream((OutputStream)this.getResponse().getOutputStream());
            this.printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)((Object)this.gzipOutputStream), this.getResponse().getCharacterEncoding()), true);
        }
        return this.printWriter;
    }

    public void setContentLength(int length) {
    }

    public void flush() throws IOException {
        if (this.printWriter != null) {
            this.printWriter.flush();
        }
        if (this.gzipOutputStream != null) {
            this.gzipOutputStream.flush();
        }
    }

    public void setDisableFlushBuffer(boolean disableFlushBuffer) {
        this.disableFlushBuffer = disableFlushBuffer;
    }
}

