/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.utils;

import com.erudika.para.server.utils.GZipServletResponseWrapper;
import java.util.Collection;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GZipResponseUtil {
    private static final Logger log = LoggerFactory.getLogger(GZipResponseUtil.class);
    private static final int EMPTY_GZIPPED_CONTENT_SIZE = 20;

    private GZipResponseUtil() {
    }

    public static boolean shouldGzippedBodyBeZero(byte[] compressedBytes, HttpServletRequest request) {
        if (compressedBytes.length == 20) {
            if (log.isTraceEnabled()) {
                log.trace("{} resulted in an empty response.", (Object)request.getRequestURL());
            }
            return true;
        }
        return false;
    }

    public static boolean shouldBodyBeZero(HttpServletRequest request, int responseStatus) {
        if (responseStatus == 204) {
            if (log.isDebugEnabled()) {
                log.debug("{} resulted in a {} response. Removing message body in accordance with RFC2616.", (Object)request.getRequestURL(), (Object)204);
            }
            return true;
        }
        if (responseStatus == 304) {
            if (log.isDebugEnabled()) {
                log.debug("{} resulted in a {} response. Removing message body in accordance with RFC2616.", (Object)request.getRequestURL(), (Object)304);
            }
            return true;
        }
        return false;
    }

    public static void addGzipHeader(HttpServletResponse response) throws ServletException {
        response.setHeader("Content-Encoding", "gzip");
        boolean containsEncoding = response.containsHeader("Content-Encoding");
        if (!containsEncoding) {
            throw new ServletException("Failure when attempting to set Content-Encoding: gzip");
        }
    }

    public static void addVaryAcceptEncoding(GZipServletResponseWrapper wrapper) {
        Collection headers = wrapper.getHeaderNames();
        String varyHeader = null;
        for (String header : headers) {
            if (!header.equals("Vary")) continue;
            varyHeader = wrapper.getHeader(header);
            break;
        }
        if (varyHeader == null) {
            wrapper.setHeader("Vary", "Accept-Encoding");
        } else if (!varyHeader.equals("*") && !varyHeader.contains("Accept-Encoding")) {
            wrapper.setHeader("Vary", varyHeader + ",Accept-Encoding");
        }
    }
}

