/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.utils;

import com.erudika.para.server.utils.BufferedServletInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.LoggerFactory;

public class BufferedRequestWrapper
extends HttpServletRequestWrapper {
    private ByteArrayInputStream bais;
    private ByteArrayOutputStream baos;
    private BufferedServletInputStream bsis;
    private byte[] buffer;

    public BufferedRequestWrapper(HttpServletRequest req) throws IOException {
        super(req);
        if (req != null) {
            int length;
            ServletInputStream is = req.getInputStream();
            this.baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((length = is.read(buf)) > 0) {
                this.baos.write(buf, 0, length);
            }
            this.buffer = this.baos.toByteArray();
        }
    }

    public ServletInputStream getInputStream() {
        try {
            this.bais = new ByteArrayInputStream(this.buffer);
            this.bsis = new BufferedServletInputStream(this.bais);
        }
        catch (Exception ex) {
            LoggerFactory.getLogger(BufferedRequestWrapper.class).error(null, (Throwable)ex);
        }
        return this.bsis;
    }
}

