/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.storage;

import com.erudika.para.core.storage.FileStore;
import com.erudika.para.core.utils.Para;
import com.erudika.para.server.storage.AWSFileStore;
import com.erudika.para.server.storage.LocalFileStore;
import com.google.inject.AbstractModule;
import java.util.ServiceLoader;
import org.apache.commons.lang3.StringUtils;

public class StorageModule
extends AbstractModule {
    protected void configure() {
        String selectedFileStore = Para.getConfig().fileStoragePlugin();
        if (StringUtils.isBlank((CharSequence)selectedFileStore)) {
            this.bindToDefault();
        } else if ("s3".equalsIgnoreCase(selectedFileStore) || AWSFileStore.class.getSimpleName().equalsIgnoreCase(selectedFileStore)) {
            this.bind(FileStore.class).to(AWSFileStore.class).asEagerSingleton();
        } else {
            FileStore fsPlugin = this.loadExternalFileStore(selectedFileStore);
            if (fsPlugin != null) {
                this.bind(FileStore.class).to(fsPlugin.getClass()).asEagerSingleton();
            } else {
                this.bindToDefault();
            }
        }
    }

    void bindToDefault() {
        this.bind(FileStore.class).to(LocalFileStore.class).asEagerSingleton();
    }

    final FileStore loadExternalFileStore(String classSimpleName) {
        ServiceLoader<FileStore> fsLoader = ServiceLoader.load(FileStore.class, Para.getParaClassLoader());
        for (FileStore fs : fsLoader) {
            if (fs == null || !classSimpleName.equalsIgnoreCase(fs.getClass().getSimpleName())) continue;
            return fs;
        }
        return null;
    }
}

