/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.storage;

import com.erudika.para.core.storage.FileStore;
import com.erudika.para.core.utils.Para;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;

public class AWSFileStore
implements FileStore {
    private static final Logger logger = LoggerFactory.getLogger(AWSFileStore.class);
    private S3Client s3;
    private String bucket;

    public AWSFileStore() {
        this(Para.getConfig().awsS3Bucket(new DefaultAwsRegionProviderChain().getRegion().id()));
    }

    public AWSFileStore(String bucket) {
        this.bucket = bucket;
        this.s3 = S3Client.create();
    }

    public InputStream load(String path) {
        if (StringUtils.startsWith((CharSequence)path, (CharSequence)"/")) {
            path = path.substring(1);
        }
        if (!StringUtils.isBlank((CharSequence)path)) {
            String key = path;
            try {
                return this.s3.getObject(b -> b.bucket(this.bucket).key(key));
            }
            catch (Exception e) {
                logger.error("Failed to load file from S3: {}", (Object)e.getMessage());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String store(String path, InputStream data) {
        if (StringUtils.startsWith((CharSequence)path, (CharSequence)"/")) {
            path = path.substring(1);
        }
        if (StringUtils.isBlank((CharSequence)path) || data == null) {
            return null;
        }
        int maxFileSizeMBytes = Para.getConfig().awsS3MaxFileSizeMb();
        try {
            HashMap<String, String> om = new HashMap<String, String>(3);
            om.put("Cache-Control", "max-age=15552000, must-revalidate");
            if (path.endsWith(".gz")) {
                om.put("Content-Encoding", "gzip");
                path = path.substring(0, path.length() - 3);
            }
            PutObjectRequest por = (PutObjectRequest)PutObjectRequest.builder().bucket(this.bucket).key(path).metadata(om).acl(ObjectCannedACL.PUBLIC_READ).build();
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                int length;
                byte[] buf = new byte[1024];
                while ((length = data.read(buf)) > 0) {
                    baos.write(buf, 0, length);
                    if (baos.size() <= maxFileSizeMBytes * 1024 * 1024) continue;
                    logger.warn("Failed to store file on S3 because it's too large - {}, {} bytes", (Object)path, (Object)baos.size());
                    String string = null;
                    return string;
                }
                this.s3.putObject(por, RequestBody.fromBytes((byte[])baos.toByteArray()));
            }
            String key = path;
            String string = this.s3.utilities().getUrl(b -> b.bucket(this.bucket).key(key)).toExternalForm();
            return string;
        }
        catch (IOException e) {
            logger.error(null, (Throwable)e);
        }
        finally {
            try {
                data.close();
            }
            catch (IOException ex) {
                logger.error(null, (Throwable)ex);
            }
        }
        return null;
    }

    public boolean delete(String path) {
        if (StringUtils.startsWith((CharSequence)path, (CharSequence)"/")) {
            path = path.substring(1);
        }
        if (!StringUtils.isBlank((CharSequence)path)) {
            String key = path;
            this.s3.deleteObject(b -> b.bucket(this.bucket).key(key));
            return true;
        }
        return false;
    }
}

