/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.security.filters;

import com.erudika.para.core.App;
import com.erudika.para.core.User;
import com.erudika.para.core.utils.Para;
import com.erudika.para.core.utils.ParaObjectUtils;
import com.erudika.para.core.utils.Utils;
import com.erudika.para.server.security.AuthenticatedUserDetails;
import com.erudika.para.server.security.OAuth1HmacSigner;
import com.erudika.para.server.security.SecurityUtils;
import com.erudika.para.server.security.UserAuthentication;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;

public class TwitterAuthFilter
extends AbstractAuthenticationProcessingFilter {
    private final CloseableHttpClient httpclient;
    private final ObjectReader jreader = ParaObjectUtils.getJsonReader(Map.class);
    private static final String FLOW_URL1 = "https://api.twitter.com/oauth/request_token";
    private static final String FLOW_URL2 = "https://api.twitter.com/oauth/authenticate?";
    private static final String FLOW_URL3 = "https://api.twitter.com/oauth/access_token";
    private static final String PROFILE_URL = "https://api.twitter.com/1.1/account/verify_credentials.json";
    public static final String TWITTER_ACTION = "twitter_auth";

    public TwitterAuthFilter(String defaultFilterProcessesUrl) {
        super(defaultFilterProcessesUrl);
        int timeout = 30;
        this.httpclient = HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout((long)timeout, TimeUnit.SECONDS).setConnectionRequestTimeout((long)timeout, TimeUnit.SECONDS).build()).build();
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String requestURI = request.getRequestURI();
        UserAuthentication userAuth = null;
        if (requestURI.endsWith(TWITTER_ACTION)) {
            String verifier = request.getParameter("oauth_verifier");
            String appid = SecurityUtils.getAppidFromAuthRequest(request);
            String denied = request.getParameter("denied");
            String redirectURI = SecurityUtils.getRedirectUrl(request) + (String)(appid == null ? "" : "?appid=" + appid);
            App app = (App)Para.getDAO().read(App.id((String)(appid == null ? Para.getConfig().getRootAppIdentifier() : appid)));
            String[] keys = Para.getConfig().getOAuthKeysForApp(app, "tw:");
            if (denied != null) {
                throw new BadCredentialsException("Cancelled.");
            }
            if (verifier == null && this.stepOne(response, redirectURI, keys)) {
                return null;
            }
            userAuth = this.stepTwo(request, verifier, keys, app);
        }
        return SecurityUtils.checkIfActive(userAuth, SecurityUtils.getAuthenticatedUser(userAuth), true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean stepOne(HttpServletResponse response, String redirectURI, String[] keys) throws IOException {
        String callback = Utils.urlEncode((String)redirectURI);
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("oauth_callback", new String[]{callback});
        HttpPost tokenPost = new HttpPost(FLOW_URL1);
        tokenPost.setHeader("Authorization", (Object)OAuth1HmacSigner.sign("POST", FLOW_URL1, params, keys[0], keys[1], null, null));
        tokenPost.setHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
        try {
            CloseableHttpResponse resp1;
            block12: {
                resp1 = this.httpclient.execute((ClassicHttpRequest)tokenPost);
                if (resp1.getCode() != 200) {
                    this.logger.info((Object)("Authentication request failed with status '" + resp1.getReasonPhrase() + "' and empty response body."));
                    return false;
                }
                break block12;
                finally {
                    if (resp1 != null) {
                        resp1.close();
                    }
                }
            }
            String decoded = EntityUtils.toString((HttpEntity)resp1.getEntity());
            EntityUtils.consumeQuietly((HttpEntity)resp1.getEntity());
            String[] stringArray = decoded.split("&");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String pair = stringArray[n2];
                if (pair.startsWith("oauth_token")) {
                    response.sendRedirect(FLOW_URL2 + pair);
                    boolean bl = true;
                    return bl;
                }
                this.logger.info((Object)("Authentication request failed, token not found in response - " + decoded));
                ++n2;
            }
            return false;
        }
        catch (ParseException e) {
            this.logger.error(null, (Throwable)e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private UserAuthentication stepTwo(HttpServletRequest request, String verifier, String[] keys, App app) throws UnsupportedEncodingException, IOException {
        String token = request.getParameter("oauth_token");
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("oauth_verifier", new String[]{verifier});
        HttpPost tokenPost = new HttpPost(FLOW_URL3);
        tokenPost.setEntity((HttpEntity)new StringEntity("oauth_verifier=" + verifier));
        tokenPost.setHeader("Authorization", (Object)OAuth1HmacSigner.sign("POST", FLOW_URL3, params, keys[0], keys[1], token, null));
        tokenPost.setHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
        try (CloseableHttpResponse resp2 = this.httpclient.execute((ClassicHttpRequest)tokenPost);){
            if (resp2.getCode() != 200) return null;
            String decoded = EntityUtils.toString((HttpEntity)resp2.getEntity());
            EntityUtils.consumeQuietly((HttpEntity)resp2.getEntity());
            String oauthToken = null;
            String oauthSecret = null;
            for (String pair : decoded.split("&")) {
                if (pair.startsWith("oauth_token_secret")) {
                    oauthSecret = pair.substring(19);
                    continue;
                }
                if (!pair.startsWith("oauth_token")) continue;
                oauthToken = pair.substring(12);
            }
            UserAuthentication userAuthentication = this.getOrCreateUser(app, oauthToken + Para.getConfig().separator() + oauthSecret);
            return userAuthentication;
        }
        catch (ParseException e) {
            this.logger.error(null, (Throwable)e);
        }
        return null;
    }

    public UserAuthentication getOrCreateUser(App app, String accessToken) throws IOException {
        UserAuthentication userAuth = null;
        User user = new User();
        if (accessToken != null && accessToken.contains(Para.getConfig().separator())) {
            String[] tokens = accessToken.split(Para.getConfig().separator());
            String[] keys = Para.getConfig().getOAuthKeysForApp(app, "tw:");
            HashMap<String, String[]> params2 = new HashMap<String, String[]>();
            HttpGet profileGet = new HttpGet("https://api.twitter.com/1.1/account/verify_credentials.json?include_email=true");
            params2.put("include_email", new String[]{"true"});
            profileGet.setHeader("Authorization", (Object)OAuth1HmacSigner.sign("GET", PROFILE_URL, params2, keys[0], keys[1], tokens[0], tokens[1]));
            Map profile = null;
            try (CloseableHttpResponse resp3 = this.httpclient.execute((ClassicHttpRequest)profileGet);){
                if (resp3.getCode() == 200) {
                    profile = (Map)this.jreader.readValue(resp3.getEntity().getContent());
                    EntityUtils.consumeQuietly((HttpEntity)resp3.getEntity());
                }
            }
            if (profile != null && profile.containsKey("id_str")) {
                String twitterId = (String)profile.get("id_str");
                String pic = (String)profile.get("profile_image_url_https");
                String alias = (String)profile.get("screen_name");
                String name = (String)profile.get("name");
                String email = (String)profile.get("email");
                user.setAppid(this.getAppid(app));
                user.setIdentifier("tw:" + twitterId);
                user.setEmail(email);
                user = User.readUserForIdentifier((User)user);
                if (user == null) {
                    user = new User();
                    user.setActive(Boolean.valueOf(true));
                    user.setAppid(this.getAppid(app));
                    user.setEmail((String)(StringUtils.isBlank((CharSequence)email) ? Utils.getNewId() + "@twitter.com" : email));
                    user.setName(StringUtils.isBlank((CharSequence)name) ? alias : name);
                    user.setPassword(Utils.generateSecurityToken());
                    user.setPicture(TwitterAuthFilter.getPicture(pic));
                    user.setIdentifier("tw:" + twitterId);
                    String id = user.create();
                    if (id == null) {
                        throw new AuthenticationServiceException("Authentication failed: cannot create new user.");
                    }
                } else if (this.updateUserInfo(user, pic, email, name)) {
                    user.update();
                }
                userAuth = new UserAuthentication(new AuthenticatedUserDetails(user));
            } else {
                this.logger.info((Object)"Authentication request failed because user profile doesn't contain the expected attributes");
            }
        }
        return SecurityUtils.checkIfActive(userAuth, user, false);
    }

    private boolean updateUserInfo(User user, String pic, String email, String name) {
        String picture = TwitterAuthFilter.getPicture(pic);
        boolean update = false;
        if (!StringUtils.equals((CharSequence)user.getPicture(), (CharSequence)picture)) {
            user.setPicture(picture);
            update = true;
        }
        if (!StringUtils.isBlank((CharSequence)email) && !StringUtils.equals((CharSequence)user.getEmail(), (CharSequence)email)) {
            user.setEmail(email);
            update = true;
        }
        if (!StringUtils.isBlank((CharSequence)name) && !StringUtils.equals((CharSequence)user.getName(), (CharSequence)name)) {
            user.setName(name);
            update = true;
        }
        return update;
    }

    private static String getPicture(String pic) {
        if (pic != null) {
            if ((pic = pic.replace("_normal", "")).contains("?")) {
                return pic.substring(0, pic.indexOf(63));
            }
            return pic;
        }
        return null;
    }

    private String getAppid(App app) {
        return app == null ? null : app.getAppIdentifier();
    }
}

