/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.security.filters;

import com.erudika.para.core.App;
import com.erudika.para.core.User;
import com.erudika.para.core.utils.Para;
import com.erudika.para.core.utils.ParaObjectUtils;
import com.erudika.para.core.utils.Utils;
import com.erudika.para.server.security.AuthenticatedUserDetails;
import com.erudika.para.server.security.SecurityUtils;
import com.erudika.para.server.security.UserAuthentication;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;

public class FacebookAuthFilter
extends AbstractAuthenticationProcessingFilter {
    private final CloseableHttpClient httpclient;
    private final ObjectReader jreader = ParaObjectUtils.getJsonReader(Map.class);
    private static final String PROFILE_URL = "https://graph.facebook.com/me?fields=name,email,picture.width(400).type(square).height(400)&access_token=";
    private static final String TOKEN_URL = "https://graph.facebook.com/oauth/access_token?code={0}&redirect_uri={1}&client_id={2}&client_secret={3}";
    public static final String FACEBOOK_ACTION = "facebook_auth";

    public FacebookAuthFilter(String defaultFilterProcessesUrl) {
        super(defaultFilterProcessesUrl);
        int timeout = 30;
        this.httpclient = HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout((long)timeout, TimeUnit.SECONDS).setConnectionRequestTimeout((long)timeout, TimeUnit.SECONDS).build()).build();
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String authCode;
        String requestURI = request.getRequestURI();
        UserAuthentication userAuth = null;
        if (requestURI.endsWith(FACEBOOK_ACTION) && !StringUtils.isBlank((CharSequence)(authCode = request.getParameter("code")))) {
            String appid = SecurityUtils.getAppidFromAuthRequest(request);
            String redirectURI = SecurityUtils.getRedirectUrl(request);
            App app = (App)Para.getDAO().read(App.id((String)(appid == null ? Para.getConfig().getRootAppIdentifier() : appid)));
            String[] keys = Para.getConfig().getOAuthKeysForApp(app, "fb:");
            String url = Utils.formatMessage((String)TOKEN_URL, (Object[])new Object[]{authCode, redirectURI, keys[0], keys[1]});
            HttpGet tokenPost = new HttpGet(url);
            try (CloseableHttpResponse resp1 = this.httpclient.execute((ClassicHttpRequest)tokenPost);){
                String token = EntityUtils.toString((HttpEntity)resp1.getEntity(), (String)Para.getConfig().defaultEncoding());
                String accessToken = this.parseAccessToken(token);
                if (accessToken != null) {
                    userAuth = this.getOrCreateUser(app, accessToken);
                } else {
                    this.logger.info((Object)("Authentication request failed with status '" + resp1.getReasonPhrase() + "' - " + token));
                }
            }
            catch (Exception e) {
                this.logger.warn((Object)("Facebook auth request failed: GET " + url), (Throwable)e);
            }
        }
        return SecurityUtils.checkIfActive(userAuth, SecurityUtils.getAuthenticatedUser(userAuth), true);
    }

    public UserAuthentication getOrCreateUser(App app, String accessToken) throws IOException {
        UserAuthentication userAuth = null;
        User user = new User();
        if (accessToken != null) {
            HttpGet profileGet = new HttpGet(PROFILE_URL + accessToken);
            try (CloseableHttpResponse resp2 = this.httpclient.execute((ClassicHttpRequest)profileGet);){
                HttpEntity respEntity = resp2.getEntity();
                String ctype = resp2.getFirstHeader("Content-Type").getValue();
                if (respEntity != null && Utils.isJsonType((String)ctype)) {
                    Map profile = (Map)this.jreader.readValue(respEntity.getContent());
                    if (profile != null && profile.containsKey("id")) {
                        String fbId = (String)profile.get("id");
                        String email = (String)profile.get("email");
                        String name = (String)profile.get("name");
                        user.setAppid(this.getAppid(app));
                        user.setIdentifier("fb:".concat(fbId));
                        user.setEmail(email);
                        user = User.readUserForIdentifier((User)user);
                        if (user == null) {
                            user = new User();
                            user.setActive(Boolean.valueOf(true));
                            user.setAppid(this.getAppid(app));
                            user.setEmail((String)(StringUtils.isBlank((CharSequence)email) ? Utils.getNewId() + "@facebook.com" : email));
                            user.setName(StringUtils.isBlank((CharSequence)name) ? "No Name" : name);
                            user.setPassword(Utils.generateSecurityToken());
                            user.setPicture(FacebookAuthFilter.getPicture(fbId));
                            user.setIdentifier("fb:".concat(fbId));
                            String id = user.create();
                            if (id == null) {
                                throw new AuthenticationServiceException("Authentication failed: cannot create new user.");
                            }
                        } else if (this.updateUserInfo(user, fbId, email, name)) {
                            user.update();
                        }
                        userAuth = new UserAuthentication(new AuthenticatedUserDetails(user));
                    } else {
                        this.logger.info((Object)"Authentication request failed because user profile doesn't contain the expected attributes");
                    }
                } else {
                    this.logger.info((Object)"Authentication request failed because response was missing or contained invalid JSON.");
                }
            }
            catch (Exception e) {
                this.logger.warn((Object)("Facebook auth request failed: GET https://graph.facebook.com/me?fields=name,email,picture.width(400).type(square).height(400)&access_token=" + accessToken), (Throwable)e);
            }
        }
        return SecurityUtils.checkIfActive(userAuth, user, false);
    }

    private boolean updateUserInfo(User user, String fbId, String email, String name) {
        String picture = FacebookAuthFilter.getPicture(fbId);
        boolean update = false;
        if (!StringUtils.equals((CharSequence)user.getPicture(), (CharSequence)picture)) {
            user.setPicture(picture);
            update = true;
        }
        if (!StringUtils.isBlank((CharSequence)email) && !StringUtils.equals((CharSequence)user.getEmail(), (CharSequence)email)) {
            user.setEmail(email);
            update = true;
        }
        if (!StringUtils.isBlank((CharSequence)name) && !StringUtils.equals((CharSequence)user.getName(), (CharSequence)name)) {
            user.setName(name);
            update = true;
        }
        return update;
    }

    private static String getPicture(String fbId) {
        if (fbId != null) {
            return "https://graph.facebook.com/" + fbId + "/picture?width=700&height=700&type=square";
        }
        return null;
    }

    private String parseAccessToken(String token) throws JsonProcessingException {
        if (token != null) {
            if (token.startsWith("access_token")) {
                return token.substring(token.indexOf(61) + 1, token.indexOf(38));
            }
            Map tokenObject = (Map)this.jreader.readValue(token);
            if (tokenObject != null && tokenObject.containsKey("access_token")) {
                return (String)tokenObject.get("access_token");
            }
        }
        return null;
    }

    private String getAppid(App app) {
        return app == null ? null : app.getAppIdentifier();
    }
}

