/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.security;

import com.erudika.para.core.App;
import com.erudika.para.core.User;
import com.erudika.para.core.utils.Para;
import com.erudika.para.core.utils.Utils;
import com.erudika.para.server.security.AuthenticatedUserDetails;
import com.erudika.para.server.utils.HttpUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.rememberme.TokenBasedRememberMeServices;

public class SimpleRememberMeServices
extends TokenBasedRememberMeServices {
    public SimpleRememberMeServices(String key, UserDetailsService userDetailsService) {
        super(key, userDetailsService);
    }

    protected String encodeCookie(String[] cookieTokens) {
        if (cookieTokens.length > 0) {
            cookieTokens[0] = Utils.base64enc((byte[])cookieTokens[0].getBytes());
        }
        return super.encodeCookie(cookieTokens);
    }

    protected String[] decodeCookie(String cookieValue) {
        String[] cookieTokens = super.decodeCookie(cookieValue);
        if (cookieTokens.length > 0) {
            cookieTokens[0] = Utils.base64dec((String)cookieTokens[0]);
        }
        return cookieTokens;
    }

    protected String makeTokenSignature(long tokenExpiryTime, String username, String password) {
        if (username != null) {
            username = Utils.base64enc((byte[])username.getBytes());
        }
        String sig = super.makeTokenSignature(tokenExpiryTime, username, password);
        return sig;
    }

    protected String retrieveUserName(Authentication authentication) {
        if (authentication.getPrincipal() instanceof UserDetails) {
            User u = ((AuthenticatedUserDetails)authentication.getPrincipal()).getUser();
            if (!App.isRoot((String)u.getAppid())) {
                return u.getAppid() + "/" + u.getIdentifier();
            }
            return u.getIdentifier();
        }
        return authentication.getPrincipal().toString();
    }

    protected void setCookie(String[] tokens, int maxAge, HttpServletRequest request, HttpServletResponse response) {
        HttpUtils.setAuthCookie(Para.getConfig().authCookieName(), this.encodeCookie(tokens), maxAge, request, response);
    }
}

