/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.security;

import com.erudika.para.server.rest.RestUtils;
import com.erudika.para.server.security.AjaxRequestMatcher;
import com.erudika.para.server.security.RestRequestMatcher;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandlerImpl;

public class SimpleAccessDeniedHandler
extends AccessDeniedHandlerImpl {
    public SimpleAccessDeniedHandler(String errorPage) {
        this.setErrorPage(errorPage);
    }

    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        if (this.isRestRequest(request)) {
            RestUtils.returnStatusResponse(response, 403, accessDeniedException.getMessage());
        } else {
            super.handle(request, response, accessDeniedException);
        }
    }

    protected boolean isRestRequest(HttpServletRequest request) {
        return RestRequestMatcher.INSTANCE.matches(request) || AjaxRequestMatcher.INSTANCE.matches(request);
    }
}

