/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.security;

import com.erudika.para.core.App;
import com.erudika.para.core.ParaObject;
import com.erudika.para.core.User;
import com.erudika.para.core.rest.Signer;
import com.erudika.para.core.utils.CoreUtils;
import com.erudika.para.core.utils.Para;
import com.erudika.para.core.utils.Utils;
import com.erudika.para.server.security.AuthenticatedUserDetails;
import com.erudika.para.server.security.JWTAuthentication;
import com.erudika.para.server.security.LDAPAuthentication;
import com.erudika.para.server.security.UserAuthentication;
import com.erudika.para.server.utils.BufferedRequestWrapper;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public final class SecurityUtils {
    private static final Logger logger = LoggerFactory.getLogger(SecurityUtils.class);

    private SecurityUtils() {
    }

    public static User getAuthenticatedUser() {
        return SecurityUtils.getAuthenticatedUser(SecurityContextHolder.getContext().getAuthentication());
    }

    public static User getAuthenticatedUser(Authentication auth) {
        User user = null;
        if (auth != null && auth.isAuthenticated() && auth.getPrincipal() instanceof AuthenticatedUserDetails) {
            user = ((AuthenticatedUserDetails)auth.getPrincipal()).getUser();
        }
        return user;
    }

    public static App getAuthenticatedApp() {
        Authentication auth;
        App app = null;
        if (SecurityContextHolder.getContext().getAuthentication() != null && (auth = SecurityContextHolder.getContext().getAuthentication()).isAuthenticated() && auth.getPrincipal() instanceof App) {
            app = (App)auth.getPrincipal();
        }
        return app;
    }

    public static App getAppFromJWTAuthentication() {
        Authentication auth;
        App app = null;
        if (SecurityContextHolder.getContext().getAuthentication() != null && (auth = SecurityContextHolder.getContext().getAuthentication()) instanceof JWTAuthentication) {
            app = ((JWTAuthentication)auth).getApp();
        }
        return app;
    }

    public static App getAppFromLdapAuthentication() {
        Authentication auth;
        App app = null;
        if (SecurityContextHolder.getContext().getAuthentication() != null && (auth = SecurityContextHolder.getContext().getAuthentication()) instanceof LDAPAuthentication) {
            app = ((LDAPAuthentication)auth).getApp();
        }
        return app;
    }

    public static App getPrincipalApp() {
        App app = SecurityUtils.getAuthenticatedApp();
        if (app != null) {
            return app;
        }
        app = SecurityUtils.getAppFromJWTAuthentication();
        if (app != null) {
            return app;
        }
        app = SecurityUtils.getAppFromLdapAuthentication();
        if (app != null) {
            return app;
        }
        User user = SecurityUtils.getAuthenticatedUser();
        if (user != null) {
            return (App)Para.getDAO().read(Para.getConfig().getRootAppIdentifier(), App.id((String)user.getAppid()));
        }
        logger.warn("Unauthenticated request - app not found in security context.");
        return null;
    }

    public static boolean checkImplicitAppPermissions(App app, ParaObject object) {
        if (app != null && object != null) {
            return SecurityUtils.isNotAnApp(object.getType()) || app.getId().equals(object.getId()) || app.isRootApp();
        }
        return false;
    }

    public static boolean isNotAnApp(String type) {
        return !StringUtils.equals((CharSequence)type, (CharSequence)Utils.type(App.class));
    }

    public static boolean checkIfUserCanModifyObject(App app, ParaObject object) {
        User user = SecurityUtils.getAuthenticatedUser();
        if (user != null && app != null && object != null && app.permissionsContainOwnKeyword(user, object)) {
            return user.canModify(object);
        }
        return true;
    }

    public static void clearSession(HttpServletRequest req) {
        HttpSession session;
        SecurityContextHolder.clearContext();
        if (req != null && (session = req.getSession(false)) != null) {
            session.invalidate();
        }
    }

    public static boolean isValidJWToken(String secret, SignedJWT jwt) {
        try {
            MACVerifier verifier;
            if (!StringUtils.isBlank((CharSequence)secret) && jwt != null && jwt.verify((JWSVerifier)(verifier = new MACVerifier(secret)))) {
                Date referenceTime = new Date();
                JWTClaimsSet claims = jwt.getJWTClaimsSet();
                Date expirationTime = claims.getExpirationTime();
                Date notBeforeTime = claims.getNotBeforeTime();
                boolean expired = expirationTime == null || expirationTime.before(referenceTime);
                boolean notYetValid = notBeforeTime != null && notBeforeTime.after(referenceTime);
                return !expired && !notYetValid;
            }
        }
        catch (JOSEException e) {
            logger.warn(null, (Throwable)e);
        }
        catch (ParseException ex) {
            logger.warn(null, (Throwable)ex);
        }
        return false;
    }

    public static SignedJWT generateSuperJWToken(App app) {
        return SecurityUtils.generateJWToken(null, app);
    }

    public static SignedJWT generateJWToken(User user, App app) {
        if (app != null) {
            try {
                Date now = new Date();
                JWTClaimsSet.Builder claimsSet = new JWTClaimsSet.Builder();
                String userSecret = "";
                claimsSet.issueTime(now);
                claimsSet.expirationTime(new Date(now.getTime() + app.getTokenValiditySec() * 1000L));
                claimsSet.notBeforeTime(now);
                claimsSet.claim("refresh", (Object)SecurityUtils.getNextRefresh(app.getTokenValiditySec()));
                claimsSet.claim("appid", (Object)app.getId());
                if (user != null) {
                    if ("true".equals(Para.getConfig().getSettingForApp(app, "security.one_session_per_user", "true"))) {
                        user.resetTokenSecret();
                        CoreUtils.getInstance().overwrite(app.getAppIdentifier(), (ParaObject)user);
                    }
                    claimsSet.subject(user.getId());
                    claimsSet.claim("idp", (Object)user.getIdentityProvider());
                    userSecret = user.getTokenSecret();
                }
                MACSigner signer = new MACSigner(app.getSecret() + userSecret);
                SignedJWT signedJWT = new SignedJWT(new JWSHeader(JWSAlgorithm.HS256), claimsSet.build());
                signedJWT.sign((JWSSigner)signer);
                return signedJWT;
            }
            catch (JOSEException e) {
                logger.warn("Unable to sign JWT: {}.", (Object)e.getMessage());
            }
        }
        return null;
    }

    public static SignedJWT generateIdToken(User user, App app) {
        if (app != null && user != null) {
            try {
                Date now = new Date();
                JWTClaimsSet.Builder claimsSet = new JWTClaimsSet.Builder();
                claimsSet.issueTime(now);
                claimsSet.expirationTime(new Date(now.getTime() + (long)(Para.getConfig().idTokenExpiresAfterSec() * 1000)));
                claimsSet.notBeforeTime(now);
                claimsSet.claim("appid", (Object)app.getId());
                claimsSet.claim("name", (Object)user.getName());
                claimsSet.claim("email", (Object)user.getEmail());
                claimsSet.claim("identifier", (Object)user.getIdentifier());
                if (StringUtils.startsWithIgnoreCase((CharSequence)user.getPicture(), (CharSequence)"http")) {
                    claimsSet.claim("picture", (Object)user.getPicture());
                } else {
                    claimsSet.claim("picture", (Object)("https://gravatar.com/avatar/" + Utils.md5((String)user.getEmail()) + "?size=400&d=retro&r=pg"));
                }
                claimsSet.subject(user.getId());
                MACSigner signer = new MACSigner(app.getSecret() + user.getTokenSecret());
                SignedJWT signedJWT = new SignedJWT(new JWSHeader(JWSAlgorithm.HS256), claimsSet.build());
                signedJWT.sign((JWSSigner)signer);
                return signedJWT;
            }
            catch (JOSEException e) {
                logger.warn("Unable to sign JWT: {}.", (Object)e.getMessage());
            }
        }
        return null;
    }

    private static long getNextRefresh(long tokenValiditySec) {
        long interval = Para.getConfig().jwtRefreshIntervalSec();
        if (tokenValiditySec < 2L * interval) {
            interval = tokenValiditySec / 2L;
        }
        return System.currentTimeMillis() + interval * 1000L;
    }

    public static UserAuthentication checkIfActive(UserAuthentication userAuth, User user, boolean throwException) {
        if (userAuth == null || user == null || user.getIdentifier() == null) {
            if (throwException) {
                throw new BadCredentialsException("Bad credentials.");
            }
            logger.debug("Bad credentials. {}", (Object)userAuth);
            return null;
        }
        if (!user.getActive().booleanValue()) {
            if (throwException) {
                throw new LockedException("Account " + user.getId() + " (" + user.getAppid() + "/" + user.getIdentifier() + ") is locked.");
            }
            logger.warn("Account {} ({}/{}) is locked.", new Object[]{user.getId(), user.getAppid(), user.getIdentifier()});
            return null;
        }
        return userAuth;
    }

    public static boolean isValidSignature(HttpServletRequest incoming, String secretKey) {
        ServletInputStream entity;
        if (incoming == null || StringUtils.isBlank((CharSequence)secretKey)) {
            return false;
        }
        String auth = incoming.getHeader("Authorization");
        String givenSig = StringUtils.substringAfter((String)auth, (String)"Signature=");
        String sigHeaders = StringUtils.substringBetween((String)auth, (String)"SignedHeaders=", (String)",");
        String credential = StringUtils.substringBetween((String)auth, (String)"Credential=", (String)",");
        String accessKey = StringUtils.substringBefore((String)credential, (String)"/");
        if (StringUtils.isBlank((CharSequence)auth)) {
            givenSig = incoming.getParameter("X-Amz-Signature");
            sigHeaders = incoming.getParameter("X-Amz-SignedHeaders");
            credential = incoming.getParameter("X-Amz-Credential");
            accessKey = StringUtils.substringBefore((String)credential, (String)"/");
        }
        HashSet<String> headersUsed = new HashSet<String>(Arrays.asList(sigHeaders.split(";")));
        HashMap<Object, String> headers = new HashMap<Object, String>();
        Enumeration e = incoming.getHeaderNames();
        while (e.hasMoreElements()) {
            String head = ((String)e.nextElement()).toLowerCase();
            if (!headersUsed.contains(head)) continue;
            headers.put(head, incoming.getHeader(head));
        }
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry entry : incoming.getParameterMap().entrySet()) {
            params.put((String)entry.getKey(), ((String[])entry.getValue())[0]);
        }
        String path = incoming.getRequestURI();
        String string = StringUtils.removeEndIgnoreCase((String)incoming.getRequestURL().toString(), (String)path);
        String httpMethod = incoming.getMethod();
        try {
            entity = incoming instanceof BufferedRequestWrapper ? incoming.getInputStream() : new BufferedRequestWrapper(incoming).getInputStream();
        }
        catch (IOException ex) {
            logger.error(null, (Throwable)ex);
            entity = null;
        }
        Signer signer = new Signer();
        Map sig = signer.sign(httpMethod, string, path, headers, params, (InputStream)entity, accessKey, secretKey);
        String auth2 = (String)sig.get("Authorization");
        String recreatedSig = StringUtils.substringAfter((String)auth2, (String)"Signature=");
        boolean signaturesMatch = StringUtils.equals((CharSequence)givenSig, (CharSequence)recreatedSig);
        if (Para.getConfig().debugRequestSignaturesEnabled()) {
            logger.info("Incoming client signature for request {} {}: {} == {} calculated by server, matching: {}", new Object[]{httpMethod, path, givenSig, recreatedSig, signaturesMatch});
        }
        return signaturesMatch;
    }

    public static String getRedirectUrl(HttpServletRequest request) {
        String url = request.getRequestURL().toString();
        if (!StringUtils.isBlank((CharSequence)request.getHeader("X-Forwarded-Proto"))) {
            return request.getHeader("X-Forwarded-Proto") + url.substring(url.indexOf(58));
        }
        if (!StringUtils.isBlank((CharSequence)request.getHeader("CloudFront-Forwarded-Proto"))) {
            return request.getHeader("CloudFront-Forwarded-Proto") + url.substring(url.indexOf(58));
        }
        return url;
    }

    public static String getAppidFromAuthRequest(HttpServletRequest request) {
        String appid1 = request.getParameter("state");
        String appid2 = request.getParameter("appid");
        if (StringUtils.isBlank((CharSequence)appid1) && StringUtils.isBlank((CharSequence)appid2)) {
            if (StringUtils.startsWith((CharSequence)request.getRequestURI(), (CharSequence)"/saml_auth/")) {
                return StringUtils.trimToNull((String)request.getRequestURI().substring("/saml_auth".length() + 1));
            }
            return null;
        }
        if (!StringUtils.isBlank((CharSequence)appid1)) {
            return StringUtils.trimToNull((String)appid1);
        }
        return StringUtils.trimToNull((String)appid2);
    }
}

