/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.security;

import com.erudika.para.core.utils.Utils;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.core.AuthenticationSource;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;
import org.springframework.security.ldap.authentication.AbstractLdapAuthenticator;
import org.springframework.security.ldap.authentication.BindAuthenticator;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.authentication.PasswordComparisonAuthenticator;
import org.springframework.security.ldap.authentication.SpringSecurityAuthenticationSource;
import org.springframework.security.ldap.search.FilterBasedLdapUserSearch;
import org.springframework.security.ldap.search.LdapUserSearch;

public final class LDAPAuthenticator
implements LdapAuthenticator {
    private static final Logger logger = LoggerFactory.getLogger(LDAPAuthenticator.class);
    private AbstractLdapAuthenticator authenticator = null;

    public LDAPAuthenticator(Map<String, String> ldapSettings) {
        if (ldapSettings != null && ldapSettings.containsKey("security.ldap.server_url")) {
            String serverUrl = ldapSettings.get("security.ldap.server_url");
            String baseDN = ldapSettings.get("security.ldap.base_dn");
            String bindDN = Utils.noSpaces((String)ldapSettings.get("security.ldap.bind_dn"), (String)"%20");
            String bindPass = ldapSettings.get("security.ldap.bind_pass");
            String userSearchBase = ldapSettings.get("security.ldap.user_search_base");
            String userSearchFilter = ldapSettings.get("security.ldap.user_search_filter");
            String userDnPattern = ldapSettings.get("security.ldap.user_dn_pattern");
            String passAttribute = ldapSettings.get("security.ldap.password_attribute");
            boolean usePasswordComparison = ldapSettings.containsKey("security.ldap.compare_passwords");
            DefaultSpringSecurityContextSource contextSource = new DefaultSpringSecurityContextSource(Arrays.asList(serverUrl), baseDN);
            contextSource.setAuthenticationSource((AuthenticationSource)new SpringSecurityAuthenticationSource());
            contextSource.setCacheEnvironmentProperties(false);
            if (!bindDN.isEmpty()) {
                contextSource.setUserDn(bindDN);
            }
            if (!bindPass.isEmpty()) {
                contextSource.setPassword(bindPass);
            }
            FilterBasedLdapUserSearch userSearch = new FilterBasedLdapUserSearch(userSearchBase, userSearchFilter, (BaseLdapPathContextSource)contextSource);
            if (usePasswordComparison) {
                PasswordComparisonAuthenticator p = new PasswordComparisonAuthenticator((BaseLdapPathContextSource)contextSource);
                p.setPasswordAttributeName(passAttribute);
                p.setUserDnPatterns(this.getUserDnPatterns(userDnPattern));
                p.setUserSearch((LdapUserSearch)userSearch);
                this.authenticator = p;
            } else {
                BindAuthenticator b = new BindAuthenticator((BaseLdapPathContextSource)contextSource);
                b.setUserDnPatterns(this.getUserDnPatterns(userDnPattern));
                b.setUserSearch((LdapUserSearch)userSearch);
                this.authenticator = b;
            }
        }
    }

    public DirContextOperations authenticate(Authentication authentication) {
        try {
            if (this.authenticator != null) {
                return this.authenticator.authenticate(authentication);
            }
        }
        catch (Exception e) {
            logger.warn("Failed to authenticate user with LDAP server: {}", (Object)e.getMessage());
        }
        throw new AuthenticationServiceException("LDAP user not found.");
    }

    private String[] getUserDnPatterns(String userDnPattern) {
        if (StringUtils.isBlank((CharSequence)userDnPattern)) {
            return new String[]{""};
        }
        if (userDnPattern.contains("|")) {
            return userDnPattern.split("\\|");
        }
        return new String[]{userDnPattern};
    }
}

