/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.security;

import com.erudika.para.core.App;
import com.erudika.para.core.ParaObject;
import com.erudika.para.core.User;
import com.erudika.para.core.utils.CoreUtils;
import com.erudika.para.core.utils.Para;
import com.erudika.para.core.utils.Utils;
import com.erudika.para.server.rest.RestUtils;
import com.erudika.para.server.security.AuthenticatedUserDetails;
import com.erudika.para.server.security.JWTAuthentication;
import com.erudika.para.server.security.RestRequestMatcher;
import com.erudika.para.server.security.SecurityUtils;
import com.erudika.para.server.security.UserAuthentication;
import com.erudika.para.server.security.filters.AmazonAuthFilter;
import com.erudika.para.server.security.filters.FacebookAuthFilter;
import com.erudika.para.server.security.filters.GenericOAuth2Filter;
import com.erudika.para.server.security.filters.GitHubAuthFilter;
import com.erudika.para.server.security.filters.GoogleAuthFilter;
import com.erudika.para.server.security.filters.LdapAuthFilter;
import com.erudika.para.server.security.filters.LinkedInAuthFilter;
import com.erudika.para.server.security.filters.MicrosoftAuthFilter;
import com.erudika.para.server.security.filters.PasswordAuthFilter;
import com.erudika.para.server.security.filters.PasswordlessAuthFilter;
import com.erudika.para.server.security.filters.SlackAuthFilter;
import com.erudika.para.server.security.filters.TwitterAuthFilter;
import com.nimbusds.jwt.SignedJWT;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.filter.GenericFilterBean;

public class JWTRestfulAuthFilter
extends GenericFilterBean {
    private AuthenticationManager authenticationManager;
    private AntPathRequestMatcher authenticationRequestMatcher;
    private FacebookAuthFilter facebookAuth;
    private GoogleAuthFilter googleAuth;
    private GitHubAuthFilter githubAuth;
    private LinkedInAuthFilter linkedinAuth;
    private TwitterAuthFilter twitterAuth;
    private MicrosoftAuthFilter microsoftAuth;
    private SlackAuthFilter slackAuth;
    private AmazonAuthFilter amazonAuth;
    private GenericOAuth2Filter oauth2Auth;
    private LdapAuthFilter ldapAuth;
    private PasswordAuthFilter passwordAuth;
    private PasswordlessAuthFilter passwordlessAuth;
    public static final String JWT_ACTION = "jwt_auth";

    public JWTRestfulAuthFilter(String defaultFilterProcessesUrl) {
        this.setFilterProcessesUrl(defaultFilterProcessesUrl);
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (this.authenticationRequestMatcher.matches(request)) {
            if ("POST".equals(request.getMethod())) {
                this.newTokenHandler(request, response);
            } else if ("GET".equals(request.getMethod())) {
                this.refreshTokenHandler(request, response);
            } else if ("DELETE".equals(request.getMethod())) {
                this.revokeAllTokensHandler(request, response);
            }
            return;
        }
        if (RestRequestMatcher.INSTANCE_STRICT.matches(request) && SecurityContextHolder.getContext().getAuthentication() == null) {
            try {
                JWTAuthentication jwtAuth = this.getJWTfromRequest(request);
                if (jwtAuth != null) {
                    Authentication auth = this.authenticationManager.authenticate((Authentication)jwtAuth);
                    this.validateDelegatedTokenIfNecessary(jwtAuth);
                    SecurityContextHolder.getContext().setAuthentication(auth);
                } else {
                    response.setHeader("WWW-Authenticate", "Bearer");
                }
            }
            catch (AuthenticationException authenticationException) {
                response.setHeader("WWW-Authenticate", "Bearer error=\"invalid_token\"");
                this.logger.debug((Object)"AuthenticationManager rejected JWT Authentication.", (Throwable)authenticationException);
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean newTokenHandler(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Response res = RestUtils.getEntity((InputStream)request.getInputStream(), Map.class);
        if (res.getStatusInfo() != Response.Status.OK) {
            RestUtils.returnStatusResponse(response, res.getStatus(), res.getEntity().toString());
            return false;
        }
        Map entity = (Map)res.getEntity();
        String provider = (String)entity.get("provider");
        String appid = (String)entity.get("appid");
        String token = (String)entity.get("token");
        if (provider != null && appid != null && token != null) {
            if (App.isRoot((String)appid)) {
                RestUtils.returnStatusResponse(response, 403, "Can't authenticate user with app '" + appid + "' using provider '" + provider + "'. Reason: clients aren't allowed to access root app.");
                return false;
            }
            App app = (App)Para.getDAO().read(App.id((String)appid));
            if (app != null) {
                UserAuthentication userAuth = this.getOrCreateUser(app, provider, token);
                User user = SecurityUtils.getAuthenticatedUser(userAuth);
                if (user == null) {
                    RestUtils.returnStatusResponse(response, 400, "Failed to authenticate user with '" + provider + "'. Check if user is active.");
                    return false;
                }
                SignedJWT newJWT = SecurityUtils.generateJWToken(user, app);
                if (newJWT != null) {
                    this.succesHandler(response, user, newJWT);
                    return true;
                }
            } else {
                RestUtils.returnStatusResponse(response, 400, "User belongs to app '" + appid + "' which does not exist. " + (App.isRoot((String)appid) ? "Make sure you have initialized Para." : ""));
                return false;
            }
        }
        RestUtils.returnStatusResponse(response, 400, "Some of the required query parameters 'provider', 'appid', 'token', are missing.");
        return false;
    }

    private boolean refreshTokenHandler(HttpServletRequest request, HttpServletResponse response) {
        JWTAuthentication jwtAuth = this.getJWTfromRequest(request);
        if (jwtAuth != null) {
            try {
                User user = SecurityUtils.getAuthenticatedUser(jwtAuth);
                if (user != null) {
                    SignedJWT newToken;
                    jwtAuth = (JWTAuthentication)this.authenticationManager.authenticate((Authentication)jwtAuth);
                    this.validateDelegatedTokenIfNecessary(jwtAuth);
                    if (jwtAuth != null && jwtAuth.getApp() != null && (newToken = SecurityUtils.generateJWToken(user, jwtAuth.getApp())) != null) {
                        this.succesHandler(response, user, newToken);
                        return true;
                    }
                }
            }
            catch (Exception ex) {
                this.logger.debug((Object)ex);
            }
        }
        response.setHeader("WWW-Authenticate", "Bearer error=\"invalid_token\"");
        RestUtils.returnStatusResponse(response, 401, "User must reauthenticate.");
        return false;
    }

    private boolean revokeAllTokensHandler(HttpServletRequest request, HttpServletResponse response) {
        JWTAuthentication jwtAuth = this.getJWTfromRequest(request);
        if (jwtAuth != null) {
            try {
                User user = SecurityUtils.getAuthenticatedUser(jwtAuth);
                if (user != null) {
                    jwtAuth = (JWTAuthentication)this.authenticationManager.authenticate((Authentication)jwtAuth);
                    this.validateDelegatedTokenIfNecessary(jwtAuth);
                    if (jwtAuth != null && jwtAuth.getApp() != null) {
                        user.resetTokenSecret();
                        CoreUtils.getInstance().overwrite(jwtAuth.getApp().getAppIdentifier(), (ParaObject)user);
                        RestUtils.returnStatusResponse(response, 200, Utils.formatMessage((String)"All tokens revoked for user {0}!", (Object[])new Object[]{user.getId()}));
                        return true;
                    }
                }
            }
            catch (Exception ex) {
                this.logger.debug((Object)ex);
            }
        }
        response.setHeader("WWW-Authenticate", "Bearer");
        RestUtils.returnStatusResponse(response, 401, "Invalid or expired token.");
        return false;
    }

    private void succesHandler(HttpServletResponse response, User user, SignedJWT token) {
        if (user != null && token != null) {
            HashMap result = new HashMap();
            try {
                HashMap<String, Object> jwt = new HashMap<String, Object>();
                jwt.put("access_token", token.serialize());
                jwt.put("refresh", token.getJWTClaimsSet().getLongClaim("refresh"));
                jwt.put("expires", token.getJWTClaimsSet().getExpirationTime().getTime());
                result.put("jwt", jwt);
                result.put("user", user);
            }
            catch (ParseException ex) {
                this.logger.info((Object)"Unable to parse JWT.", (Throwable)ex);
                RestUtils.returnStatusResponse(response, 500, "Bad token.");
            }
            RestUtils.returnObjectResponse(response, result);
        } else {
            RestUtils.returnStatusResponse(response, 500, "Null token.");
        }
    }

    private JWTAuthentication getJWTfromRequest(HttpServletRequest request) {
        String token = request.getHeader("Authorization");
        if (token == null) {
            token = request.getParameter("Authorization");
        }
        if (!StringUtils.isBlank((CharSequence)token) && token.contains("Bearer")) {
            try {
                SignedJWT jwt = SignedJWT.parse((String)token.substring(6).trim());
                String userid = jwt.getJWTClaimsSet().getSubject();
                String appid = (String)jwt.getJWTClaimsSet().getClaim("appid");
                App app = (App)Para.getDAO().read(App.id((String)appid));
                if (app != null) {
                    User user = (User)Para.getDAO().read(app.getAppIdentifier(), userid);
                    if (user != null) {
                        return new JWTAuthentication(new AuthenticatedUserDetails(user)).withJWT(jwt).withApp(app);
                    }
                    return new JWTAuthentication(null).withJWT(jwt).withApp(app);
                }
            }
            catch (ParseException e) {
                this.logger.debug((Object)"Unable to parse JWT.", (Throwable)e);
            }
        }
        return null;
    }

    private UserAuthentication getOrCreateUser(App app, String identityProvider, String accessToken) throws IOException {
        if ("facebook".equalsIgnoreCase(identityProvider)) {
            return this.facebookAuth.getOrCreateUser(app, accessToken);
        }
        if ("google".equalsIgnoreCase(identityProvider)) {
            return this.googleAuth.getOrCreateUser(app, accessToken);
        }
        if ("github".equalsIgnoreCase(identityProvider)) {
            return this.githubAuth.getOrCreateUser(app, accessToken);
        }
        if ("linkedin".equalsIgnoreCase(identityProvider)) {
            return this.linkedinAuth.getOrCreateUser(app, accessToken);
        }
        if ("twitter".equalsIgnoreCase(identityProvider)) {
            return this.twitterAuth.getOrCreateUser(app, accessToken);
        }
        if ("microsoft".equalsIgnoreCase(identityProvider)) {
            return this.microsoftAuth.getOrCreateUser(app, accessToken);
        }
        if ("slack".equalsIgnoreCase(identityProvider)) {
            return this.slackAuth.getOrCreateUser(app, accessToken);
        }
        if ("amazon".equalsIgnoreCase(identityProvider)) {
            return this.amazonAuth.getOrCreateUser(app, accessToken);
        }
        if ("oauth2".equalsIgnoreCase(identityProvider)) {
            return this.oauth2Auth.getOrCreateUser(app, accessToken);
        }
        if ("oauth2second".equalsIgnoreCase(identityProvider)) {
            return this.oauth2Auth.getOrCreateUser(app, accessToken, "second");
        }
        if ("oauth2third".equalsIgnoreCase(identityProvider)) {
            return this.oauth2Auth.getOrCreateUser(app, accessToken, "third");
        }
        if ("ldap".equalsIgnoreCase(identityProvider)) {
            return this.ldapAuth.getOrCreateUser(app, accessToken);
        }
        if ("passwordless".equalsIgnoreCase(identityProvider)) {
            return this.passwordlessAuth.getOrCreateUser(app, accessToken);
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)identityProvider, (CharSequence[])new CharSequence[]{"password", "generic"})) {
            return this.passwordAuth.getOrCreateUser(app, accessToken);
        }
        return null;
    }

    private void setFilterProcessesUrl(String filterProcessesUrl) {
        this.authenticationRequestMatcher = new AntPathRequestMatcher(filterProcessesUrl);
    }

    protected AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.authenticationManager, (String)"authenticationManager cannot be null");
    }

    public FacebookAuthFilter getFacebookAuth() {
        return this.facebookAuth;
    }

    @Inject
    public void setFacebookAuth(FacebookAuthFilter facebookAuth) {
        this.facebookAuth = facebookAuth;
    }

    public GoogleAuthFilter getGoogleAuth() {
        return this.googleAuth;
    }

    @Inject
    public void setGoogleAuth(GoogleAuthFilter googleAuth) {
        this.googleAuth = googleAuth;
    }

    public GitHubAuthFilter getGithubAuth() {
        return this.githubAuth;
    }

    @Inject
    public void setGithubAuth(GitHubAuthFilter githubAuth) {
        this.githubAuth = githubAuth;
    }

    public LinkedInAuthFilter getLinkedinAuth() {
        return this.linkedinAuth;
    }

    @Inject
    public void setLinkedinAuth(LinkedInAuthFilter linkedinAuth) {
        this.linkedinAuth = linkedinAuth;
    }

    public TwitterAuthFilter getTwitterAuth() {
        return this.twitterAuth;
    }

    @Inject
    public void setTwitterAuth(TwitterAuthFilter twitterAuth) {
        this.twitterAuth = twitterAuth;
    }

    public MicrosoftAuthFilter getMicrosoftAuth() {
        return this.microsoftAuth;
    }

    @Inject
    public void setMicrosoftAuth(MicrosoftAuthFilter microsoftAuth) {
        this.microsoftAuth = microsoftAuth;
    }

    public SlackAuthFilter getSlackAuth() {
        return this.slackAuth;
    }

    @Inject
    public void setSlackAuth(SlackAuthFilter slackAuth) {
        this.slackAuth = slackAuth;
    }

    public AmazonAuthFilter getAmazonAuth() {
        return this.amazonAuth;
    }

    @Inject
    public void setAmazonAuth(AmazonAuthFilter amazonAuth) {
        this.amazonAuth = amazonAuth;
    }

    public GenericOAuth2Filter getGenericOAuth2Auth() {
        return this.oauth2Auth;
    }

    @Inject
    public void setGenericOAuth2Auth(GenericOAuth2Filter oauthAuth) {
        this.oauth2Auth = oauthAuth;
    }

    public LdapAuthFilter getLdapAuth() {
        return this.ldapAuth;
    }

    public void setLdapAuth(LdapAuthFilter ldapAuth) {
        this.ldapAuth = ldapAuth;
    }

    public PasswordAuthFilter getPasswordAuth() {
        return this.passwordAuth;
    }

    @Inject
    public void setPasswordAuth(PasswordAuthFilter passwordAuth) {
        this.passwordAuth = passwordAuth;
    }

    public PasswordlessAuthFilter getPasswordlessAuth() {
        return this.passwordlessAuth;
    }

    @Inject
    public void setPasswordlessAuth(PasswordlessAuthFilter passwordlessAuth) {
        this.passwordlessAuth = passwordlessAuth;
    }

    private void validateDelegatedTokenIfNecessary(JWTAuthentication jwt) throws AuthenticationException, IOException {
        User user = SecurityUtils.getAuthenticatedUser(jwt);
        if (user != null && jwt != null) {
            String identityProvider = null;
            try {
                identityProvider = (String)jwt.getJwt().getJWTClaimsSet().getClaim("idp");
            }
            catch (ParseException ex) {
                this.logger.error(null, (Throwable)ex);
            }
            if (StringUtils.isBlank((CharSequence)identityProvider)) {
                identityProvider = user.getIdentityProvider();
            }
            App app = jwt.getApp();
            if ("oauth2".equalsIgnoreCase(identityProvider) && this.oauth2Auth.isAccessTokenDelegationEnabled(app, user) && !this.oauth2Auth.isValidAccessToken(app, user)) {
                this.logger.debug((Object)("The access token delegated from '" + identityProvider + "' is invalid for " + user.getAppid() + "/" + user.getId()));
                throw new AuthenticationServiceException("The access token delegated from '" + identityProvider + "' is invalid.");
            }
        }
    }
}

