/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.security;

import com.erudika.para.server.security.IgnoredRequestMatcher;
import com.erudika.para.server.security.RestRequestMatcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.web.util.matcher.RequestMatcher;

public final class CsrfProtectionRequestMatcher
implements RequestMatcher {
    public static final RequestMatcher INSTANCE = new CsrfProtectionRequestMatcher();
    private final Pattern allowedMethods = Pattern.compile("^(GET|HEAD|TRACE|OPTIONS)$");
    private final Pattern authEndpoints = Pattern.compile("^/\\w+_auth$");
    private final Pattern passAuthEndpoint = Pattern.compile("^/password_auth$");
    private final Pattern samlEndpoint = Pattern.compile("^/saml_auth.*$");
    private final Pattern samlMetaEndpoint = Pattern.compile("^/saml_metadata.*$");

    private CsrfProtectionRequestMatcher() {
    }

    public boolean matches(HttpServletRequest request) {
        boolean matches = !RestRequestMatcher.INSTANCE.matches(request) && !IgnoredRequestMatcher.INSTANCE.matches(request) && !this.samlMetaEndpoint.matcher(request.getRequestURI()).matches() && !this.samlEndpoint.matcher(request.getRequestURI()).matches() && !this.authEndpoints.matcher(request.getRequestURI()).matches() && !this.allowedMethods.matcher(request.getMethod()).matches();
        return matches || this.passAuthEndpoint.matcher(request.getRequestURI()).matches();
    }
}

