/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.security;

import com.erudika.para.core.App;
import com.erudika.para.core.User;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.Collections;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class AuthenticatedUserDetails
implements UserDetails {
    private static final long serialVersionUID = 1L;
    private User user;

    public AuthenticatedUserDetails(User user) {
        assert (user != null);
        this.user = user;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    @JsonIgnore
    public Collection<? extends GrantedAuthority> getAuthorities() {
        if (this.user.isAdmin()) {
            return Collections.singleton(new SimpleGrantedAuthority(User.Roles.ADMIN.toString()));
        }
        if (this.user.isModerator()) {
            return Collections.singleton(new SimpleGrantedAuthority(User.Roles.MOD.toString()));
        }
        return Collections.singleton(new SimpleGrantedAuthority(User.Roles.USER.toString()));
    }

    @JsonIgnore
    public String getUsername() {
        if (App.isRoot((String)this.user.getAppid())) {
            return this.user.getIdentifier();
        }
        return this.user.getAppid() + "/" + this.user.getIdentifier();
    }

    @JsonIgnore
    public boolean isAccountNonExpired() {
        return this.user.getActive();
    }

    @JsonIgnore
    public boolean isAccountNonLocked() {
        return this.user.getActive();
    }

    @JsonIgnore
    public boolean isCredentialsNonExpired() {
        return this.user.getActive();
    }

    @JsonIgnore
    public boolean isEnabled() {
        return this.user.getActive();
    }

    @JsonIgnore
    public String getPassword() {
        return this.user.getPassword();
    }

    public String getIdentifier() {
        return this.user.getIdentifier();
    }
}

