/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.metrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Slf4jReporter;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.codahale.metrics.jmx.JmxReporter;
import com.erudika.para.core.App;
import com.erudika.para.core.listeners.InitializeListener;
import com.erudika.para.core.metrics.Metrics;
import com.erudika.para.core.rest.CustomResourceHandler;
import com.erudika.para.core.utils.Pager;
import com.erudika.para.core.utils.Para;
import com.erudika.para.core.utils.RegistryUtils;
import com.erudika.para.core.utils.Utils;
import com.erudika.para.server.rest.RestUtils;
import com.erudika.para.server.utils.HealthUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum MetricsUtils implements InitializeListener,
Runnable
{
    INSTANCE{
        private ScheduledFuture<?> scheduledRegistryCheck;

        public void onInitialize() {
            if (!Para.getConfig().metricsEnabled()) {
                return;
            }
            MetricRegistry systemRegistry = SharedMetricRegistries.tryGetDefault();
            if (systemRegistry == null) {
                systemRegistry = SharedMetricRegistries.setDefault((String)"_system");
            }
            Logger metricsLogger = LoggerFactory.getLogger((String)"paraMetrics");
            int loggingRate = Para.getConfig().metricsLoggingIntervalSec();
            if (loggingRate > 0) {
                Slf4jReporter.forRegistry((MetricRegistry)systemRegistry).outputTo(metricsLogger).build().start((long)loggingRate, TimeUnit.SECONDS);
            }
            MetricsUtils.initializeMetrics("_system");
            String host = Para.getConfig().metricsGraphiteHost();
            if (GRAPHITE_PERIOD > 0 && !StringUtils.isBlank((CharSequence)host)) {
                int port = Para.getConfig().metricsGraphitePort();
                String prefixSystem = GRAPHITE_SYS_PREFIX_TEMPLATE;
                if (INSTANCE_ID != null) {
                    HashMap<String, String> prefixContext = new HashMap<String, String>();
                    prefixContext.put("INSTANCE_ID", INSTANCE_ID);
                    prefixSystem = Utils.compileMustache(prefixContext, (String)prefixSystem);
                }
                GraphiteSettings settings = new GraphiteSettings(host, port);
                MetricsUtils.createGraphiteReporter("_system", settings, prefixSystem);
            }
            if (HealthUtils.getInstance().isHealthy()) {
                List appsPage;
                Pager pager = new Pager(1L, "_docid", false, 10000);
                long appCount = 0L;
                do {
                    appsPage = Para.getSearch().findQuery(Utils.type(App.class), "*", new Pager[]{pager});
                    appCount += (long)appsPage.size();
                    appsPage.forEach(app -> {
                        logger.debug("   {}{}", (Object)app.getAppIdentifier(), (Object)(app.isRootApp() ? " (root app)" : ""));
                        MetricsUtils.initializeMetrics(app.getAppIdentifier());
                    });
                    logger.debug("Found a page of {} apps.", (Object)appsPage.size());
                } while (!appsPage.isEmpty());
                logger.info("Found root app '{}' and {} existing child app(s){}", new Object[]{Para.getConfig().getRootAppIdentifier(), appCount == 0L ? 0L : appCount - 1L, appCount == 0L || !logger.isDebugEnabled() ? "." : ":"});
            }
            if (this.scheduledRegistryCheck == null) {
                this.scheduledRegistryCheck = Para.getScheduledExecutorService().scheduleAtFixedRate(this, 0L, 1L, TimeUnit.MINUTES);
            }
            App.addAppCreatedListener(app -> {
                if (app != null) {
                    MetricsUtils.initializeMetrics(app.getAppIdentifier());
                }
            });
            App.addAppSettingAddedListener((app, key, value) -> MetricsUtils.addAppSetting(app, key, value));
            App.addAppSettingRemovedListener((app, key) -> 1.removeAppSetting(app, key));
        }

        @Override
        public void run() {
            MetricsUtils.syncAppMetricsReporters();
        }
    };

    private static final Logger logger;
    private static final String INSTANCE_ID;
    private static final Map<String, GraphiteReporter> GRAPHITE_REPORTERS;
    private static final Map<String, GraphiteSettings> GRAPHITE_SETTINGS;
    private static final String GRAPHITE_SYS_PREFIX_TEMPLATE;
    private static final String GRAPHITE_APP_PREFIX_TEMPLATE;
    private static final int GRAPHITE_PERIOD;
    public static final String GRAPHITE_REGISTRY_NAME = "GraphiteReporter";
    public static final String GRAPHITE_APP_SETTINGS_NAME = "metricsGraphiteReporter";

    public static MetricsUtils getInstance() {
        return INSTANCE;
    }

    private static void initializeMetrics(String registryName) {
        MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)registryName);
        if (Para.getDAO() != null) {
            String daoClassName = Metrics.getClassName(Para.getDAO().getClass());
            registry.timer(MetricRegistry.name((String)daoClassName, (String[])new String[]{"create"}));
            registry.timer(MetricRegistry.name((String)daoClassName, (String[])new String[]{"read"}));
            registry.timer(MetricRegistry.name((String)daoClassName, (String[])new String[]{"update"}));
            registry.timer(MetricRegistry.name((String)daoClassName, (String[])new String[]{"delete"}));
            registry.timer(MetricRegistry.name((String)daoClassName, (String[])new String[]{"createAll"}));
            registry.timer(MetricRegistry.name((String)daoClassName, (String[])new String[]{"readAll"}));
            registry.timer(MetricRegistry.name((String)daoClassName, (String[])new String[]{"readPage"}));
            registry.timer(MetricRegistry.name((String)daoClassName, (String[])new String[]{"updateAll"}));
            registry.timer(MetricRegistry.name((String)daoClassName, (String[])new String[]{"deleteAll"}));
        }
        if (Para.getConfig().isSearchEnabled()) {
            String searchClassName = Metrics.getClassName(Para.getSearch().getClass());
            registry.timer(MetricRegistry.name((String)searchClassName, (String[])new String[]{"index"}));
            registry.timer(MetricRegistry.name((String)searchClassName, (String[])new String[]{"unindex"}));
            registry.timer(MetricRegistry.name((String)searchClassName, (String[])new String[]{"indexAll"}));
            registry.timer(MetricRegistry.name((String)searchClassName, (String[])new String[]{"unindexAll"}));
            registry.timer(MetricRegistry.name((String)searchClassName, (String[])new String[]{"findById"}));
            registry.timer(MetricRegistry.name((String)searchClassName, (String[])new String[]{"findByIds"}));
            registry.timer(MetricRegistry.name((String)searchClassName, (String[])new String[]{"findNearby"}));
            registry.timer(MetricRegistry.name((String)searchClassName, (String[])new String[]{"findPrefix"}));
            registry.timer(MetricRegistry.name((String)searchClassName, (String[])new String[]{"findQuery"}));
            registry.timer(MetricRegistry.name((String)searchClassName, (String[])new String[]{"findNestedQuery"}));
            registry.timer(MetricRegistry.name((String)searchClassName, (String[])new String[]{"findSimilar"}));
            registry.timer(MetricRegistry.name((String)searchClassName, (String[])new String[]{"findTagged"}));
            registry.timer(MetricRegistry.name((String)searchClassName, (String[])new String[]{"findTags"}));
            registry.timer(MetricRegistry.name((String)searchClassName, (String[])new String[]{"findTermInList"}));
            registry.timer(MetricRegistry.name((String)searchClassName, (String[])new String[]{"findTerms"}));
            registry.timer(MetricRegistry.name((String)searchClassName, (String[])new String[]{"findWildcard"}));
            registry.timer(MetricRegistry.name((String)searchClassName, (String[])new String[]{"getCount"}));
            registry.timer(MetricRegistry.name((String)searchClassName, (String[])new String[]{"rebuildIndex"}));
        }
        if (Para.getConfig().isCacheEnabled()) {
            String cacheClassName = Metrics.getClassName(Para.getCache().getClass());
            registry.timer(MetricRegistry.name((String)cacheClassName, (String[])new String[]{"contains"}));
            registry.timer(MetricRegistry.name((String)cacheClassName, (String[])new String[]{"put"}));
            registry.timer(MetricRegistry.name((String)cacheClassName, (String[])new String[]{"get"}));
            registry.timer(MetricRegistry.name((String)cacheClassName, (String[])new String[]{"remove"}));
            registry.timer(MetricRegistry.name((String)cacheClassName, (String[])new String[]{"putAll"}));
            registry.timer(MetricRegistry.name((String)cacheClassName, (String[])new String[]{"getAll"}));
            registry.timer(MetricRegistry.name((String)cacheClassName, (String[])new String[]{"removeAll"}));
        }
        if (Para.getConfig().apiEnabled()) {
            String restUtilsClassName = Metrics.getClassName(RestUtils.class);
            registry.timer(MetricRegistry.name((String)restUtilsClassName, (String[])new String[]{"crud", "read"}));
            registry.timer(MetricRegistry.name((String)restUtilsClassName, (String[])new String[]{"crud", "create"}));
            registry.timer(MetricRegistry.name((String)restUtilsClassName, (String[])new String[]{"crud", "overwrite"}));
            registry.timer(MetricRegistry.name((String)restUtilsClassName, (String[])new String[]{"crud", "update"}));
            registry.timer(MetricRegistry.name((String)restUtilsClassName, (String[])new String[]{"crud", "delete"}));
            registry.timer(MetricRegistry.name((String)restUtilsClassName, (String[])new String[]{"batch", "read"}));
            registry.timer(MetricRegistry.name((String)restUtilsClassName, (String[])new String[]{"batch", "create"}));
            registry.timer(MetricRegistry.name((String)restUtilsClassName, (String[])new String[]{"batch", "update"}));
            registry.timer(MetricRegistry.name((String)restUtilsClassName, (String[])new String[]{"batch", "delete"}));
            registry.timer(MetricRegistry.name((String)restUtilsClassName, (String[])new String[]{"links", "read"}));
            registry.timer(MetricRegistry.name((String)restUtilsClassName, (String[])new String[]{"links", "delete"}));
            registry.timer(MetricRegistry.name((String)restUtilsClassName, (String[])new String[]{"links", "create"}));
            registry.timer(MetricRegistry.name((String)restUtilsClassName, (String[])new String[]{"search", "id"}));
            registry.timer(MetricRegistry.name((String)restUtilsClassName, (String[])new String[]{"search", "ids"}));
            registry.timer(MetricRegistry.name((String)restUtilsClassName, (String[])new String[]{"search", "nested"}));
            registry.timer(MetricRegistry.name((String)restUtilsClassName, (String[])new String[]{"search", "nearby"}));
            registry.timer(MetricRegistry.name((String)restUtilsClassName, (String[])new String[]{"search", "prefix"}));
            registry.timer(MetricRegistry.name((String)restUtilsClassName, (String[])new String[]{"search", "similar"}));
            registry.timer(MetricRegistry.name((String)restUtilsClassName, (String[])new String[]{"search", "tagged"}));
            registry.timer(MetricRegistry.name((String)restUtilsClassName, (String[])new String[]{"search", "in"}));
            registry.timer(MetricRegistry.name((String)restUtilsClassName, (String[])new String[]{"search", "terms"}));
            registry.timer(MetricRegistry.name((String)restUtilsClassName, (String[])new String[]{"search", "wildcard"}));
            registry.timer(MetricRegistry.name((String)restUtilsClassName, (String[])new String[]{"search", "count"}));
            registry.timer(MetricRegistry.name((String)restUtilsClassName, (String[])new String[]{"search", "default"}));
        }
        for (CustomResourceHandler handler : Para.getCustomResourceHandlers()) {
            String resourceHandlerClassName = Metrics.getClassName(handler.getClass());
            registry.timer(MetricRegistry.name((String)resourceHandlerClassName, (String[])new String[]{"handleGet"}));
            registry.timer(MetricRegistry.name((String)resourceHandlerClassName, (String[])new String[]{"handlePost"}));
            registry.timer(MetricRegistry.name((String)resourceHandlerClassName, (String[])new String[]{"handlePatch"}));
            registry.timer(MetricRegistry.name((String)resourceHandlerClassName, (String[])new String[]{"handlePut"}));
            registry.timer(MetricRegistry.name((String)resourceHandlerClassName, (String[])new String[]{"handleDelete"}));
        }
        if (Para.getConfig().metricsJmxEnabled()) {
            JmxReporter.forRegistry((MetricRegistry)registry).inDomain(registryName).build().start();
        }
    }

    private static void createAppGraphiteReporter(String appid, GraphiteSettings settings) {
        HashMap<String, String> prefixContext = new HashMap<String, String>();
        prefixContext.put("APP_ID", appid);
        if (INSTANCE_ID != null) {
            prefixContext.put("INSTANCE_ID", INSTANCE_ID);
        }
        String appPrefix = Utils.compileMustache(prefixContext, (String)GRAPHITE_APP_PREFIX_TEMPLATE);
        MetricsUtils.createGraphiteReporter(appid, settings, appPrefix);
    }

    private static void createGraphiteReporter(String registryName, GraphiteSettings settings, String prefix) {
        Graphite graphite = new Graphite(settings.getHost(), settings.getPort());
        GraphiteReporter reporter = GraphiteReporter.forRegistry((MetricRegistry)SharedMetricRegistries.getOrCreate((String)registryName)).prefixedWith(prefix).build(graphite);
        reporter.start((long)GRAPHITE_PERIOD, TimeUnit.SECONDS);
        GRAPHITE_REPORTERS.put(registryName, reporter);
        GRAPHITE_SETTINGS.put(registryName, settings);
        logger.info("Created Graphite reporter for registry \"{}\", pushing to {{}:{}}", new Object[]{registryName, settings.getHost(), settings.getPort()});
    }

    private static void addAppSetting(App app, String key, Object value) {
        Map graphiteSettings;
        if (app != null && GRAPHITE_APP_SETTINGS_NAME.equals(key) && Map.class.isAssignableFrom(value.getClass()) && (graphiteSettings = (Map)value).containsKey("host") && graphiteSettings.containsKey("port")) {
            String host = (String)graphiteSettings.get("host");
            Integer port = (Integer)graphiteSettings.get("port");
            if (!StringUtils.isBlank((CharSequence)host) && port != null && port > 0) {
                GraphiteSettings settings = new GraphiteSettings(host, port);
                RegistryUtils.putValue((String)GRAPHITE_REGISTRY_NAME, (String)app.getAppIdentifier(), (Object)settings);
            }
        }
    }

    public static void removeAppSetting(App app, String key) {
        if (app != null && GRAPHITE_APP_SETTINGS_NAME.equals(key)) {
            RegistryUtils.removeValue((String)GRAPHITE_REGISTRY_NAME, (String)app.getAppIdentifier());
        }
    }

    private static void syncAppMetricsReporters() {
        Map graphiteRegistry = RegistryUtils.getRegistry((String)GRAPHITE_REGISTRY_NAME);
        if (graphiteRegistry != null && GRAPHITE_PERIOD > 0) {
            for (Map.Entry iter : graphiteRegistry.entrySet()) {
                String string = (String)iter.getKey();
                GraphiteSettings settings = GraphiteSettings.parse(iter.getValue());
                if (settings == null) continue;
                if (GRAPHITE_REPORTERS.containsKey(string)) {
                    if (settings.equals(GRAPHITE_SETTINGS.get(string))) continue;
                    GRAPHITE_REPORTERS.get(string).stop();
                    GRAPHITE_REPORTERS.remove(string);
                    GRAPHITE_SETTINGS.remove(string);
                    MetricsUtils.createAppGraphiteReporter(string, settings);
                    continue;
                }
                MetricsUtils.createAppGraphiteReporter(string, settings);
            }
            ArrayList<Map.Entry<String, GraphiteReporter>> appsToRemove = new ArrayList<Map.Entry<String, GraphiteReporter>>();
            for (Map.Entry<String, GraphiteReporter> entry : GRAPHITE_REPORTERS.entrySet()) {
                if (entry.getKey().equals("_system") || graphiteRegistry.containsKey(entry.getKey())) continue;
                appsToRemove.add(entry);
            }
            for (Map.Entry<String, Object> entry : appsToRemove) {
                ((GraphiteReporter)entry.getValue()).stop();
                GRAPHITE_REPORTERS.remove(entry.getKey());
                GRAPHITE_SETTINGS.remove(entry.getKey());
            }
        }
    }

    static {
        logger = LoggerFactory.getLogger(MetricsUtils.class);
        INSTANCE_ID = Para.getConfig().workerId();
        GRAPHITE_REPORTERS = new HashMap<String, GraphiteReporter>();
        GRAPHITE_SETTINGS = new HashMap<String, GraphiteSettings>();
        GRAPHITE_SYS_PREFIX_TEMPLATE = Para.getConfig().metricsGraphitePrefixSystem();
        GRAPHITE_APP_PREFIX_TEMPLATE = Para.getConfig().metricsGraphitePrefixApps();
        GRAPHITE_PERIOD = Para.getConfig().metricsGraphitePeriodSec();
    }

    private static final class GraphiteSettings
    extends HashMap<String, Object> {
        GraphiteSettings(String host, int port) {
            this.put("host", host);
            this.put("port", port);
        }

        public String getHost() {
            return (String)this.get("host");
        }

        public int getPort() {
            return (Integer)this.get("port");
        }

        public static GraphiteSettings parse(Object object) {
            Map map = (Map)object;
            if (map == null || !map.containsKey("host") || !map.containsKey("port")) {
                return null;
            }
            return new GraphiteSettings((String)map.get("host"), (Integer)map.get("port"));
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return Objects.equals(this.getHost(), ((GraphiteSettings)obj).getHost()) && Objects.equals(this.getPort(), ((GraphiteSettings)obj).getPort());
        }

        @Override
        public int hashCode() {
            return 67 * Objects.hashCode(this.getPort()) + Objects.hashCode(this.getHost());
        }
    }
}

