/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.email;

import com.erudika.para.core.email.Emailer;
import com.erudika.para.core.utils.Para;
import java.util.Iterator;
import java.util.List;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ses.SesClient;
import software.amazon.awssdk.services.ses.SesClientBuilder;
import software.amazon.awssdk.services.ses.model.Body;
import software.amazon.awssdk.services.ses.model.Content;
import software.amazon.awssdk.services.ses.model.Destination;
import software.amazon.awssdk.services.ses.model.Message;
import software.amazon.awssdk.services.ses.model.SendEmailRequest;

@Singleton
public class AWSEmailer
implements Emailer {
    private final SesClient sesclient = (SesClient)((SesClientBuilder)SesClient.builder().region(Region.of((String)Para.getConfig().awsSesRegion()))).build();

    public boolean sendEmail(List<String> emails, String subject, String body) {
        if (emails != null && !emails.isEmpty() && !StringUtils.isBlank((CharSequence)body)) {
            final SendEmailRequest.Builder request = SendEmailRequest.builder();
            request.source(Para.getConfig().supportEmail()).build();
            Iterator<String> emailz = emails.iterator();
            Destination.Builder dest = Destination.builder();
            dest.toAddresses(new String[]{emailz.next()});
            while (emailz.hasNext()) {
                dest.bccAddresses(new String[]{emailz.next()});
            }
            request.destination((Destination)dest.build());
            Message.Builder msg = Message.builder();
            msg.subject((Content)Content.builder().data(subject).build());
            msg.body((Body)Body.builder().html((Content)Content.builder().data(body).charset(Para.getConfig().defaultEncoding()).build()).build());
            request.message((Message)msg.build());
            Para.asyncExecute((Runnable)new Runnable(){

                @Override
                public void run() {
                    AWSEmailer.this.sesclient.sendEmail((SendEmailRequest)request.build());
                }
            });
            return true;
        }
        return false;
    }
}

