/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.core.utils;

import com.erudika.para.core.Sysprop;
import com.erudika.para.core.utils.CoreUtils;
import com.erudika.para.core.utils.Para;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class RegistryUtils {
    private static final String REGISTRY_PREFIX = "Registry:";
    private static final String REGISTRY_APP_ID = Para.getConfig().getRootAppIdentifier();

    private RegistryUtils() {
    }

    public static void putValue(String registryName, String key, Object value) {
        if (StringUtils.isBlank((CharSequence)registryName) || StringUtils.isBlank((CharSequence)key) || value == null) {
            return;
        }
        Sysprop registryObject = RegistryUtils.readRegistryObject(registryName);
        if (registryObject == null) {
            registryObject = new Sysprop(RegistryUtils.getRegistryID(registryName));
            registryObject.addProperty(key, value);
            CoreUtils.getInstance().getDao().create(REGISTRY_APP_ID, registryObject);
        } else {
            registryObject.addProperty(key, value);
            CoreUtils.getInstance().getDao().update(REGISTRY_APP_ID, registryObject);
        }
    }

    public static Object getValue(String registryName, String key) {
        Map<String, Object> registry = RegistryUtils.getRegistry(registryName);
        if (registry == null || StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        return registry.get(key);
    }

    public static void removeValue(String registryName, String key) {
        Sysprop registryObject = RegistryUtils.readRegistryObject(registryName);
        if (registryObject == null || StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        if (registryObject.hasProperty(key)) {
            registryObject.removeProperty(key);
            CoreUtils.getInstance().getDao().update(REGISTRY_APP_ID, registryObject);
        }
    }

    public static Map<String, Object> getRegistry(String registryName) {
        if (StringUtils.isBlank((CharSequence)registryName)) {
            return null;
        }
        Sysprop registryObject = RegistryUtils.readRegistryObject(registryName);
        return registryObject == null ? null : registryObject.getProperties();
    }

    private static Sysprop readRegistryObject(String registryName) {
        return (Sysprop)CoreUtils.getInstance().getDao().read(REGISTRY_APP_ID, RegistryUtils.getRegistryID(registryName));
    }

    private static String getRegistryID(String registryName) {
        return REGISTRY_PREFIX + registryName;
    }
}

