/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.core.utils;

import com.erudika.para.core.App;
import com.erudika.para.core.ParaObject;
import com.erudika.para.core.cache.Cache;
import com.erudika.para.core.listeners.DestroyListener;
import com.erudika.para.core.listeners.IOListener;
import com.erudika.para.core.listeners.InitializeListener;
import com.erudika.para.core.persistence.DAO;
import com.erudika.para.core.queue.Queue;
import com.erudika.para.core.rest.CustomResourceHandler;
import com.erudika.para.core.search.Search;
import com.erudika.para.core.storage.FileStore;
import com.erudika.para.core.utils.CoreUtils;
import com.erudika.para.core.utils.ParaConfig;
import com.erudika.para.core.utils.ParaObjectUtils;
import com.erudika.para.core.utils.RateLimiter;
import com.erudika.para.core.utils.VersionInfo;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Para {
    private static final ParaConfig CONF = new ParaConfig();
    public static final String LOGO;
    private static final Logger logger;
    private static final Set<DestroyListener> DESTROY_LISTENERS;
    private static final Set<InitializeListener> INIT_LISTENERS;
    private static final Set<IOListener> IO_LISTENERS;
    private static final Set<IOListener> SEARCH_LISTENERS;
    private static final ExecutorService EXECUTOR;
    private static final ScheduledExecutorService SCHEDULER;
    private static ClassLoader paraClassLoader;
    private static volatile boolean isInitialized;

    private Para() {
    }

    public static void initialize() {
        if (isInitialized) {
            return;
        }
        isInitialized = true;
        Para.printLogo();
        try {
            logger.info("--- Para.initialize() [{}] ---", (Object)CONF.environment());
            for (InitializeListener initListener : INIT_LISTENERS) {
                if (initListener == null) continue;
                initListener.onInitialize();
                logger.debug("Executed {}.onInitialize().", (Object)initListener.getClass().getName());
            }
        }
        catch (Exception e) {
            logger.error("Failed to initialize Para.", (Throwable)e);
        }
    }

    public static void destroy() {
        try {
            logger.info("--- Para.destroy() ---");
            for (DestroyListener destroyListener : DESTROY_LISTENERS) {
                if (destroyListener == null) continue;
                destroyListener.onDestroy();
                logger.debug("Executed {}.onDestroy().", (Object)destroyListener.getClass().getName());
            }
            if (!EXECUTOR.isShutdown()) {
                EXECUTOR.shutdown();
                EXECUTOR.awaitTermination(60L, TimeUnit.SECONDS);
            }
            if (!SCHEDULER.isShutdown()) {
                SCHEDULER.shutdown();
                SCHEDULER.awaitTermination(60L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException e) {
            logger.error("Interrupted while shutting down Para.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public static DAO getDAO() {
        return CoreUtils.getInstance().getDao();
    }

    public static Search getSearch() {
        return CoreUtils.getInstance().getSearch();
    }

    public static Cache getCache() {
        return CoreUtils.getInstance().getCache();
    }

    public static Queue getQueue() {
        return CoreUtils.getInstance().getQueue();
    }

    public static FileStore getFileStore() {
        return CoreUtils.getInstance().getFileStore();
    }

    public static void addInitListener(InitializeListener il) {
        if (il != null) {
            INIT_LISTENERS.add(il);
        }
    }

    public static Set<InitializeListener> getInitListeners() {
        return Collections.unmodifiableSet(INIT_LISTENERS);
    }

    public static void addDestroyListener(DestroyListener dl) {
        if (dl != null) {
            DESTROY_LISTENERS.add(dl);
        }
    }

    public static Set<DestroyListener> getDestroyListeners() {
        return Collections.unmodifiableSet(DESTROY_LISTENERS);
    }

    public static void addIOListener(IOListener iol) {
        if (iol != null) {
            IO_LISTENERS.add(iol);
        }
    }

    public static Set<IOListener> getIOListeners() {
        return Collections.unmodifiableSet(IO_LISTENERS);
    }

    public static void addSearchQueryListener(IOListener iol) {
        if (iol != null) {
            SEARCH_LISTENERS.add(iol);
        }
    }

    public static Set<IOListener> getSearchQueryListeners() {
        return Collections.unmodifiableSet(SEARCH_LISTENERS);
    }

    public static ExecutorService getExecutorService() {
        return EXECUTOR;
    }

    public static ScheduledExecutorService getScheduledExecutorService() {
        return SCHEDULER;
    }

    public static void asyncExecute(Runnable runnable) {
        if (runnable != null) {
            try {
                Para.getExecutorService().execute(runnable);
            }
            catch (RejectedExecutionException ex) {
                logger.warn(ex.getMessage());
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    logger.error(null, (Throwable)e);
                }
            }
        }
    }

    public static ScheduledFuture<?> asyncExecutePeriodically(Runnable task, long delay, long interval, TimeUnit t) {
        if (task != null) {
            try {
                return Para.getScheduledExecutorService().scheduleAtFixedRate(task, delay, interval, t);
            }
            catch (RejectedExecutionException ex) {
                logger.warn(ex.getMessage());
            }
        }
        return null;
    }

    public static RateLimiter createRateLimiter(int rateLimitPerMin, int rateLimitPerHour) {
        return new RateLimiter(rateLimitPerMin, rateLimitPerHour);
    }

    public static RateLimiter createRateLimiter(int rateLimitPerMin, int rateLimitPerHour, int rateLimitPerDay) {
        return new RateLimiter(rateLimitPerMin, rateLimitPerHour, rateLimitPerDay);
    }

    public static List<CustomResourceHandler> getCustomResourceHandlers() {
        ServiceLoader<CustomResourceHandler> loader = ServiceLoader.load(CustomResourceHandler.class, Para.getParaClassLoader());
        ArrayList<CustomResourceHandler> externalResources = new ArrayList<CustomResourceHandler>();
        for (CustomResourceHandler handler : loader) {
            if (handler == null) continue;
            externalResources.add(handler);
        }
        return externalResources;
    }

    public static ClassLoader getParaClassLoader() {
        if (paraClassLoader == null) {
            try {
                ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
                ArrayList<URL> jars = new ArrayList<URL>();
                File lib = new File(CONF.pluginFolder());
                if (lib.exists() && lib.isDirectory()) {
                    for (File file : FileUtils.listFiles((File)lib, (String[])new String[]{"jar"}, (boolean)false)) {
                        jars.add(file.toURI().toURL());
                    }
                }
                paraClassLoader = new URLClassLoader((URL[])jars.toArray(URL[]::new), currentClassLoader);
            }
            catch (Exception e) {
                logger.error(null, (Throwable)e);
            }
        }
        return paraClassLoader;
    }

    public static void registerCoreClasses(Class<? extends ParaObject> ... classes) {
        ParaObjectUtils.registerCoreClasses(classes);
    }

    public static Map<String, String> setup() {
        return Para.newApp(Para.getConfig().getRootAppIdentifier(), CONF.appName(), false, false);
    }

    public static Map<String, String> newApp(String appid, String name, boolean sharedTable, boolean sharedIndex) {
        return Para.newApp(appid, name, null, sharedTable, sharedIndex);
    }

    public static Map<String, String> newApp(String appid, String name, String creatorid, boolean sharedTable, boolean sharedIndex) {
        TreeMap<String, String> creds = new TreeMap<String, String>();
        creds.put("message", "All set!");
        if (StringUtils.isBlank((CharSequence)appid)) {
            return creds;
        }
        App app = new App(appid);
        if (!app.exists()) {
            app.setName(StringUtils.isBlank((CharSequence)name) ? appid : name);
            app.setSharingTable(sharedTable);
            app.setSharingIndex(sharedIndex);
            app.setCreatorid(creatorid);
            app.setActive(true);
            String id = app.create();
            if (id != null) {
                logger.info("Created {} app '{}', sharingTable = {}, sharingIndex = {}.", new Object[]{app.isRootApp() ? "root" : "new", app.getAppIdentifier(), sharedTable, sharedIndex});
                creds.putAll(app.getCredentials());
                creds.put("message", "Save these keys - they are shown only once!");
            } else {
                logger.error("Failed to create app '{}'!", (Object)appid);
                creds.put("message", "Error - app was not created.");
            }
        }
        return creds;
    }

    public static void printLogo() {
        if (CONF.logoBannerEnabled()) {
            System.out.print(LOGO);
        }
    }

    public static String getVersion() {
        return VersionInfo.getVersion();
    }

    public static ParaConfig getConfig() {
        return CONF;
    }

    static {
        boolean printVer = CONF.versionBannerEnabled();
        String[] logo = new String[]{"", "      ____  ___ _ ____ ___ _ ", "     / __ \\/ __` / ___/ __` /", "    / /_/ / /_/ / /  / /_/ / ", "   / .___/\\__,_/_/   \\__,_/  " + (String)(printVer ? "v" + Para.getVersion() : ""), "  /_/                        ", ""};
        StringBuilder sb = new StringBuilder();
        for (String line : logo) {
            sb.append(line).append("\n");
        }
        LOGO = sb.toString();
        logger = LoggerFactory.getLogger(Para.class);
        DESTROY_LISTENERS = new LinkedHashSet<DestroyListener>();
        INIT_LISTENERS = new LinkedHashSet<InitializeListener>();
        IO_LISTENERS = new LinkedHashSet<IOListener>();
        SEARCH_LISTENERS = new LinkedHashSet<IOListener>();
        EXECUTOR = Executors.newFixedThreadPool(CONF.executorThreads());
        SCHEDULER = Executors.newScheduledThreadPool(CONF.executorThreads());
        isInitialized = false;
        Para.addInitListener(CoreUtils.getInstance());
    }
}

