/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.core.utils;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.LoggerFactory;

public final class HumanTime
implements Externalizable,
Comparable<HumanTime> {
    private static final long serialVersionUID = 5179328390732826722L;
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private static final long MONTH = 2592000000L;
    private static final long YEAR = 31536000000L;
    private static final int CEILING_PERCENTAGE = 100;
    private long delta;

    static State getState(char c) {
        if (Character.toString(c).matches("[0-9]")) {
            return State.NUMBER;
        }
        if (Character.toString(c).matches("[smhdySMHDY]")) {
            return State.UNIT;
        }
        return State.IGNORED;
    }

    public static HumanTime eval(final CharSequence s) {
        HumanTime out = new HumanTime(0L);
        int num = 0;
        int start = 0;
        int end = 0;
        State oldState = State.IGNORED;
        for (char c : new Iterable<Character>(){

            @Override
            public Iterator<Character> iterator() {
                return new Iterator<Character>(){
                    private int p = 0;

                    @Override
                    public boolean hasNext() {
                        return this.p < s.length();
                    }

                    @Override
                    public Character next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return Character.valueOf(s.charAt(this.p++));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }) {
            State newState = HumanTime.getState(c);
            if (oldState != newState) {
                if (oldState == State.NUMBER && (newState == State.IGNORED || newState == State.UNIT)) {
                    num = Integer.parseInt(s.subSequence(start, end).toString());
                } else if (oldState == State.UNIT && (newState == State.IGNORED || newState == State.NUMBER)) {
                    out.nTimes(s.subSequence(start, end).toString(), num);
                    num = 0;
                }
                start = end;
            }
            ++end;
            oldState = newState;
        }
        if (oldState == State.UNIT) {
            out.nTimes(s.subSequence(start, end).toString(), num);
        }
        return out;
    }

    public static String exactly(CharSequence in) {
        return HumanTime.eval(in).getExactly();
    }

    public static String exactly(long l) {
        return new HumanTime(l).getExactly();
    }

    public static String approximately(CharSequence in) {
        return HumanTime.eval(in).getApproximately();
    }

    public static String approximately(long l) {
        return new HumanTime(l).getApproximately();
    }

    public HumanTime() {
        this(0L);
    }

    public HumanTime(long delta) {
        this.delta = Math.abs(delta);
    }

    private void nTimes(String unit, int n) {
        if ("ms".equalsIgnoreCase(unit)) {
            this.ms(n);
        } else if ("s".equalsIgnoreCase(unit)) {
            this.s(n);
        } else if ("m".equalsIgnoreCase(unit)) {
            this.m(n);
        } else if ("h".equalsIgnoreCase(unit)) {
            this.h(n);
        } else if ("d".equalsIgnoreCase(unit)) {
            this.d(n);
        } else if ("y".equalsIgnoreCase(unit)) {
            this.y(n);
        }
    }

    private long upperCeiling(long x) {
        return x / 100L * 0L;
    }

    private long lowerCeiling(long x) {
        return x / 100L * 100L;
    }

    private String ceil(long d, long n) {
        return Integer.toString((int)Math.ceil((double)d / (double)n));
    }

    private String floor(long d, long n) {
        return Integer.toString((int)Math.floor((double)d / (double)n));
    }

    public HumanTime y() {
        return this.y(1);
    }

    public HumanTime y(int n) {
        this.delta += 31536000000L * (long)Math.abs(n);
        return this;
    }

    public HumanTime d() {
        return this.d(1);
    }

    public HumanTime d(int n) {
        this.delta += 86400000L * (long)Math.abs(n);
        return this;
    }

    public HumanTime h() {
        return this.h(1);
    }

    public HumanTime h(int n) {
        this.delta += 3600000L * (long)Math.abs(n);
        return this;
    }

    public HumanTime m() {
        return this.m(1);
    }

    public HumanTime m(int n) {
        this.delta += 60000L * (long)Math.abs(n);
        return this;
    }

    public HumanTime s() {
        return this.s(1);
    }

    public HumanTime s(int n) {
        this.delta += 1000L * (long)Math.abs(n);
        return this;
    }

    public HumanTime ms() {
        return this.ms(1);
    }

    public HumanTime ms(int n) {
        this.delta += (long)Math.abs(n);
        return this;
    }

    public String getExactly() {
        return this.getExactly(new StringBuilder()).toString();
    }

    public <T extends Appendable> T getExactly(T a) {
        try {
            boolean prependBlank = false;
            long d = this.delta;
            if (d >= 31536000000L) {
                a.append(this.floor(d, 31536000000L));
                a.append(' ');
                a.append('y');
                prependBlank = true;
            }
            if ((d %= 31536000000L) >= 86400000L) {
                if (prependBlank) {
                    a.append(' ');
                }
                a.append(this.floor(d, 86400000L));
                a.append(' ');
                a.append('d');
                prependBlank = true;
            }
            if ((d %= 86400000L) >= 3600000L) {
                if (prependBlank) {
                    a.append(' ');
                }
                a.append(this.floor(d, 3600000L));
                a.append(' ');
                a.append('h');
                prependBlank = true;
            }
            if ((d %= 3600000L) >= 60000L) {
                if (prependBlank) {
                    a.append(' ');
                }
                a.append(this.floor(d, 60000L));
                a.append(' ');
                a.append('m');
                prependBlank = true;
            }
            if ((d %= 60000L) >= 1000L) {
                if (prependBlank) {
                    a.append(' ');
                }
                a.append(this.floor(d, 1000L));
                a.append(' ');
                a.append('s');
                prependBlank = true;
            }
            if ((d %= 1000L) > 0L) {
                if (prependBlank) {
                    a.append(' ');
                }
                a.append(Integer.toString((int)d));
                a.append(' ');
                a.append('m');
                a.append('s');
            }
        }
        catch (IOException ex) {
            LoggerFactory.getLogger(HumanTime.class).warn(null, (Throwable)ex);
        }
        return a;
    }

    public String getApproximately() {
        return this.getApproximately(new StringBuilder()).toString();
    }

    public <T extends Appendable> T getApproximately(T a) {
        try {
            MutableInt parts = new MutableInt(0);
            long d = this.delta;
            long mod = d % 31536000000L;
            if (!(this.append(d, mod, 31536000000L, 'y', a, parts) || this.append(d %= 31536000000L, mod = d % 2592000000L, 2592000000L, 'n', a, parts) || parts.intValue() >= 2 || this.append(d %= 2592000000L, mod = d % 86400000L, 86400000L, 'd', a, parts) || parts.intValue() >= 2 || this.append(d %= 86400000L, mod = d % 3600000L, 3600000L, 'h', a, parts) || parts.intValue() >= 2 || this.append(d %= 3600000L, mod = d % 60000L, 60000L, 'm', a, parts) || parts.intValue() >= 2 || this.append(d %= 60000L, mod = d % 1000L, 1000L, 's', a, parts) || parts.intValue() >= 2 || (d %= 1000L) <= 0L)) {
                a.append(Integer.toString((int)d));
                a.append('m');
                a.append('s');
            }
        }
        catch (IOException ex) {
            LoggerFactory.getLogger(HumanTime.class).warn(null, (Throwable)ex);
        }
        return a;
    }

    private boolean append(long d, long mod, long unit, char u, Appendable a, MutableInt parts) throws IOException {
        if (d >= unit) {
            a.append(this.floor(d, unit));
            a.append(u);
            parts.increment();
            if (mod <= this.lowerCeiling(unit)) {
                return true;
            }
        }
        return false;
    }

    public long getDelta() {
        return this.delta;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HumanTime)) {
            return false;
        }
        return this.delta == ((HumanTime)obj).delta;
    }

    public int hashCode() {
        return (int)(this.delta ^ this.delta >> 32);
    }

    public String toString() {
        return this.getExactly();
    }

    @Override
    public int compareTo(HumanTime t) {
        return this.delta == t.delta ? 0 : (this.delta < t.delta ? -1 : 1);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.delta = in.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.delta);
    }

    static enum State {
        NUMBER,
        IGNORED,
        UNIT;

    }
}

