/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.core;

import com.erudika.para.core.Linker;
import com.erudika.para.core.ParaObject;
import com.erudika.para.core.Votable;
import com.erudika.para.core.annotations.Locked;
import com.erudika.para.core.annotations.Stored;
import com.erudika.para.core.utils.CoreUtils;
import com.erudika.para.core.utils.Pager;
import com.erudika.para.core.utils.Para;
import com.erudika.para.core.utils.ParaObjectUtils;
import com.erudika.para.core.utils.Utils;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

public class Address
implements ParaObject {
    private static final long serialVersionUID = 1L;
    @Stored
    @Locked
    private String id;
    @Stored
    @Locked
    private Long timestamp;
    @Stored
    @Locked
    private String type;
    @Stored
    @Locked
    private String appid;
    @Stored
    @Locked
    private String parentid;
    @Stored
    @Locked
    private String creatorid;
    @Stored
    private Long updated;
    @Stored
    private String name;
    @Stored
    private List<String> tags;
    @Stored
    private Integer votes;
    @Stored
    private Long version;
    @Stored
    private Boolean stored;
    @Stored
    private Boolean indexed;
    @Stored
    private Boolean cached;
    @Stored
    @NotBlank
    @Size(min=3, max=255)
    private @NotBlank @Size(min=3, max=255) String address;
    @Stored
    @NotBlank
    @Size(min=2, max=255)
    private @NotBlank @Size(min=2, max=255) String country;
    @Stored
    @Size(min=0, max=255)
    private @Size(min=0, max=255) String city;
    @Stored
    @NotBlank
    private String latlng;
    @Stored
    private String phone;

    public Address() {
        this(null);
    }

    public Address(String id) {
        this.setId(id);
        this.setName(this.getName());
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getLatlng() {
        return this.latlng;
    }

    public void setLatlng(String latlng) {
        this.latlng = latlng;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public final void setId(String id) {
        this.id = id;
    }

    @Override
    public final String getType() {
        this.type = this.type == null ? Utils.type(this.getClass()) : this.type;
        return this.type;
    }

    @Override
    public final void setType(String type) {
        this.type = type;
    }

    @Override
    public String getAppid() {
        this.appid = this.appid == null ? Para.getConfig().getRootAppIdentifier() : this.appid;
        return this.appid;
    }

    @Override
    public void setAppid(String appid) {
        this.appid = appid;
    }

    @Override
    public String getObjectURI() {
        return CoreUtils.getInstance().getObjectURI(this);
    }

    @Override
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    public Boolean getStored() {
        if (this.stored == null) {
            this.stored = true;
        }
        return this.stored;
    }

    @Override
    public void setStored(Boolean stored) {
        this.stored = stored;
    }

    @Override
    public Boolean getIndexed() {
        if (this.indexed == null) {
            this.indexed = true;
        }
        return this.indexed;
    }

    @Override
    public void setIndexed(Boolean indexed) {
        this.indexed = indexed;
    }

    @Override
    public Boolean getCached() {
        if (this.cached == null) {
            this.cached = true;
        }
        return this.cached;
    }

    @Override
    public void setCached(Boolean cached) {
        this.cached = cached;
    }

    @Override
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp != null && this.timestamp != 0L ? this.timestamp : null;
    }

    @Override
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String getCreatorid() {
        return this.creatorid;
    }

    @Override
    public void setCreatorid(String creatorid) {
        this.creatorid = creatorid;
    }

    @Override
    public final String getName() {
        return CoreUtils.getInstance().getName(this.name, this.id);
    }

    @Override
    public final void setName(String name) {
        this.name = name == null || !name.isEmpty() ? name : this.name;
    }

    @Override
    public String getPlural() {
        return Utils.singularToPlural(this.getType());
    }

    @Override
    public String getParentid() {
        return this.parentid;
    }

    @Override
    public void setParentid(String parentid) {
        this.parentid = parentid;
    }

    @Override
    public Long getUpdated() {
        return this.updated != null && this.updated != 0L ? this.updated : null;
    }

    @Override
    public void setUpdated(Long updated) {
        this.updated = updated;
    }

    @Override
    public String create() {
        return CoreUtils.getInstance().getDao().create(this.getAppid(), this);
    }

    @Override
    public void update() {
        CoreUtils.getInstance().getDao().update(this.getAppid(), this);
    }

    @Override
    public void delete() {
        CoreUtils.getInstance().getDao().delete(this.getAppid(), this);
    }

    @Override
    public boolean exists() {
        return CoreUtils.getInstance().getDao().read(this.getAppid(), this.getId()) != null;
    }

    @Override
    public boolean voteUp(String userid) {
        return CoreUtils.getInstance().vote(this, userid, Votable.VoteValue.UP);
    }

    @Override
    public boolean voteDown(String userid) {
        return CoreUtils.getInstance().vote(this, userid, Votable.VoteValue.DOWN);
    }

    @Override
    public Integer getVotes() {
        return this.votes == null ? 0 : this.votes;
    }

    @Override
    public void setVotes(Integer votes) {
        this.votes = votes;
    }

    @Override
    public Long getVersion() {
        return this.version == null ? 0L : this.version;
    }

    @Override
    public void setVersion(Long version) {
        this.version = version;
    }

    @Override
    public Long countLinks(String type2) {
        return CoreUtils.getInstance().countLinks(this, type2);
    }

    @Override
    public List<Linker> getLinks(String type2, Pager ... pager) {
        return CoreUtils.getInstance().getLinks(this, type2, pager);
    }

    @Override
    public <P extends ParaObject> List<P> getLinkedObjects(String type, Pager ... pager) {
        return CoreUtils.getInstance().getLinkedObjects(this, type, pager);
    }

    @Override
    public <P extends ParaObject> List<P> findLinkedObjects(String type, String field, String query, Pager ... pager) {
        return CoreUtils.getInstance().findLinkedObjects(this, type, field, query, pager);
    }

    @Override
    public boolean isLinked(String type2, String id2) {
        return CoreUtils.getInstance().isLinked(this, type2, id2);
    }

    @Override
    public boolean isLinked(ParaObject toObj) {
        return CoreUtils.getInstance().isLinked(this, toObj);
    }

    @Override
    public String link(String id2) {
        return CoreUtils.getInstance().link(this, id2);
    }

    @Override
    public void unlink(String type, String id2) {
        CoreUtils.getInstance().unlink(this, type, id2);
    }

    @Override
    public void unlinkAll() {
        CoreUtils.getInstance().unlinkAll(this);
    }

    @Override
    public Long countChildren(String type) {
        return CoreUtils.getInstance().countChildren(this, type);
    }

    @Override
    public <P extends ParaObject> List<P> getChildren(String type, Pager ... pager) {
        return CoreUtils.getInstance().getChildren((ParaObject)this, type, pager);
    }

    @Override
    public <P extends ParaObject> List<P> getChildren(String type, String field, String term, Pager ... pager) {
        return CoreUtils.getInstance().getChildren((ParaObject)this, type, field, term, pager);
    }

    @Override
    public <P extends ParaObject> List<P> findChildren(String type, String query, Pager ... pager) {
        return CoreUtils.getInstance().findChildren(this, type, query, pager);
    }

    @Override
    public void deleteChildren(String type) {
        CoreUtils.getInstance().deleteChildren(this, type);
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.id) + Objects.hashCode(this.name);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParaObject other = (ParaObject)obj;
        return Objects.equals(this.id, other.getId());
    }

    public String toString() {
        return ParaObjectUtils.toJSON(this);
    }
}

