/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.rest;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.util.SdkHttpUtils;
import com.erudika.para.core.utils.ParaObjectUtils;
import com.erudika.para.utils.Config;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Signer
extends AWS4Signer {
    private static final Logger logger = LoggerFactory.getLogger(Signer.class);
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormat.forPattern((String)"yyyyMMdd'T'HHmmss'Z'").withZoneUTC();

    public Signer() {
        super(false);
        super.setServiceName("para");
        super.setRegionName("us-east-1");
    }

    public Map<String, String> sign(String httpeMethod, String endpoint, String resourcePath, Map<String, String> headers, Map<String, String> params, InputStream entity, String accessKey, String secretKey) {
        Request<?> req = this.buildAWSRequest(httpeMethod, endpoint, resourcePath, headers, params, entity);
        this.sign(req, accessKey, secretKey);
        return req.getHeaders();
    }

    public void sign(Request<?> request, String accessKey, String secretKey) {
        super.sign(request, (AWSCredentials)new BasicAWSCredentials(accessKey, secretKey));
        this.resetDate();
    }

    private void resetDate() {
        this.overriddenDate = null;
    }

    private Request<?> buildAWSRequest(String httpMethod, String endpoint, String resourcePath, Map<String, String> headers, Map<String, String> params, InputStream entity) {
        DefaultRequest r = new DefaultRequest("para");
        if (!StringUtils.isBlank((CharSequence)httpMethod)) {
            r.setHttpMethod(HttpMethodName.valueOf((String)httpMethod));
        }
        if (!StringUtils.isBlank((CharSequence)endpoint)) {
            if (!endpoint.startsWith("http")) {
                endpoint = "https://" + endpoint;
            }
            r.setEndpoint(URI.create(endpoint));
        }
        if (!StringUtils.isBlank((CharSequence)resourcePath)) {
            r.setResourcePath(SdkHttpUtils.urlEncode((String)resourcePath, (boolean)true));
        }
        if (headers != null) {
            if (headers.containsKey("x-amz-date")) {
                this.overriddenDate = Signer.parseAWSDate(headers.get("x-amz-date"));
            }
            headers.remove("host");
            headers.remove("x-amz-date");
            r.setHeaders(headers);
        }
        if (params != null) {
            for (Map.Entry<String, String> param : params.entrySet()) {
                r.addParameter(param.getKey(), param.getValue());
            }
        }
        if (entity != null) {
            r.setContent(entity);
        }
        return r;
    }

    public static Date parseAWSDate(String date) {
        if (date == null) {
            return null;
        }
        return TIME_FORMATTER.parseDateTime(date).toDate();
    }

    public Response invokeSignedRequest(Client apiClient, String accessKey, String secretKey, String httpMethod, String endpointURL, String reqPath, Map<String, String> headers, MultivaluedMap<String, String> params, Entity<?> entity) {
        byte[] jsonEntity = null;
        if (entity != null) {
            try {
                jsonEntity = ParaObjectUtils.getJsonWriter().writeValueAsBytes(entity.getEntity());
            }
            catch (JsonProcessingException ex) {
                jsonEntity = null;
                logger.error(null, (Throwable)ex);
            }
        }
        return this.invokeSignedRequest(apiClient, accessKey, secretKey, httpMethod, endpointURL, reqPath, headers, params, jsonEntity);
    }

    public Response invokeSignedRequest(Client apiClient, String accessKey, String secretKey, String httpMethod, String endpointURL, String reqPath, Map<String, String> headers, MultivaluedMap<String, String> params, byte[] jsonEntity) {
        boolean isJWT = StringUtils.startsWithIgnoreCase((CharSequence)secretKey, (CharSequence)"Bearer");
        WebTarget target = apiClient.target(endpointURL).path(reqPath);
        Map<Object, Object> signedHeaders = new HashMap();
        if (!isJWT) {
            signedHeaders = this.signRequest(accessKey, secretKey, httpMethod, endpointURL, reqPath, headers, params, jsonEntity);
        }
        if (params != null) {
            for (Object param : params.entrySet()) {
                String string = (String)param.getKey();
                List value = (List)param.getValue();
                if (value == null || value.isEmpty() || value.get(0) == null) continue;
                target = target.queryParam(string, value.toArray());
            }
        }
        Invocation.Builder builder = target.request(new String[]{"application/json"});
        if (headers != null) {
            for (Map.Entry entry : headers.entrySet()) {
                builder.header((String)entry.getKey(), entry.getValue());
            }
        }
        Entity jsonPayload = null;
        if (jsonEntity != null && jsonEntity.length > 0) {
            try {
                jsonPayload = Entity.json((Object)new String(jsonEntity, Config.DEFAULT_ENCODING));
            }
            catch (IOException iOException) {
                logger.error(null, (Throwable)iOException);
            }
        }
        if (isJWT) {
            builder.header("Authorization", (Object)secretKey);
        } else {
            builder.header("Authorization", signedHeaders.get("Authorization")).header("X-Amz-Date", signedHeaders.get("X-Amz-Date"));
        }
        if (jsonPayload != null) {
            return builder.method(httpMethod, jsonPayload);
        }
        return builder.method(httpMethod);
    }

    public Map<String, String> signRequest(String accessKey, String secretKey, String httpMethod, String endpointURL, String reqPath, Map<String, String> headers, MultivaluedMap<String, String> params, byte[] jsonEntity) {
        if (StringUtils.isBlank((CharSequence)accessKey)) {
            logger.error("Blank access key: {} {}", (Object)httpMethod, (Object)reqPath);
            return headers;
        }
        if (StringUtils.isBlank((CharSequence)secretKey)) {
            logger.debug("Anonymous request: {} {}", (Object)httpMethod, (Object)reqPath);
            if (headers == null) {
                headers = new HashMap<String, String>();
            }
            headers.put("Authorization", "Anonymous " + accessKey);
            return headers;
        }
        if (httpMethod == null) {
            httpMethod = "GET";
        }
        ByteArrayInputStream in = null;
        HashMap<String, String> sigParams = new HashMap<String, String>();
        if (params != null) {
            for (Map.Entry param : params.entrySet()) {
                String key = (String)param.getKey();
                List value = (List)param.getValue();
                if (value == null || value.isEmpty() || value.get(0) == null) continue;
                sigParams.put(key, (String)value.get(0));
            }
        }
        if (jsonEntity != null && jsonEntity.length > 0) {
            in = new ByteArrayInputStream(jsonEntity);
        }
        return this.sign(httpMethod, endpointURL, reqPath, headers, sigParams, in, accessKey, secretKey);
    }
}

