/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.i18n;

import java.text.NumberFormat;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum CurrencyUtils {
    INSTANCE{
        private final transient Logger logger = LoggerFactory.getLogger(CurrencyUtils.class);
        private final Map<String, Locale> countryToLocaleMap = new HashMap<String, Locale>();
        private final Map<String, Locale> currencyToLocaleMap = new HashMap<String, Locale>();
        private final Map<String, String> currenciesMap = new TreeMap<String, String>();
        {
            Locale[] locales = Locale.getAvailableLocales();
            try {
                for (Locale l : locales) {
                    if (StringUtils.isBlank((CharSequence)l.getCountry())) continue;
                    this.countryToLocaleMap.put(l.getCountry(), l);
                    Currency c = Currency.getInstance(l);
                    if (c == null) continue;
                    this.currencyToLocaleMap.put(c.getCurrencyCode(), l);
                    this.currenciesMap.put(c.getCurrencyCode(), this.getCurrencyName(c.getCurrencyCode(), Locale.US).concat(" ").concat(c.getSymbol(l)));
                }
                this.currencyToLocaleMap.put("USD", Locale.US);
                this.currencyToLocaleMap.put("EUR", Locale.FRANCE);
            }
            catch (Exception e) {
                this.logger.error(null, (Throwable)e);
            }
        }

        @Override
        public String formatPrice(Double price, String cur) {
            String formatted = "";
            if (price != null) {
                Locale locale = this.currencyToLocaleMap.get(cur);
                NumberFormat f = locale == null ? NumberFormat.getCurrencyInstance(Locale.US) : NumberFormat.getCurrencyInstance(locale);
                f.setMinimumFractionDigits(2);
                formatted = f.format(price);
            }
            return formatted;
        }

        @Override
        public String getCurrencyName(String cur, Locale locale) {
            if (cur != null && this.currencyToLocaleMap.containsKey(cur.toUpperCase())) {
                return Currency.getInstance(cur.toUpperCase()).getDisplayName(locale == null ? Locale.US : locale);
            }
            return "";
        }

        @Override
        public Locale getLocaleForCountry(String countryCode) {
            if (countryCode == null) {
                return null;
            }
            return this.countryToLocaleMap.get(countryCode.toUpperCase());
        }

        @Override
        public Currency getCurrency(String cur) {
            Currency currency = Currency.getInstance("EUR");
            if (StringUtils.isBlank((CharSequence)cur) || cur.length() != 3) {
                return currency;
            }
            try {
                currency = Currency.getInstance(cur.toUpperCase());
            }
            catch (Exception e) {
                this.logger.error(null, (Throwable)e);
            }
            return currency;
        }

        @Override
        public Map<String, String> getCurrenciesMap() {
            return this.currenciesMap;
        }

        @Override
        public boolean isValidCurrency(String cur) {
            return cur != null && this.currenciesMap.containsKey(cur.toUpperCase());
        }
    };


    public abstract String formatPrice(Double var1, String var2);

    public abstract String getCurrencyName(String var1, Locale var2);

    public abstract Locale getLocaleForCountry(String var1);

    public abstract Currency getCurrency(String var1);

    public abstract Map<String, String> getCurrenciesMap();

    public abstract boolean isValidCurrency(String var1);

    public static CurrencyUtils getInstance() {
        return INSTANCE;
    }
}

