/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.builders;

import com.epam.ta.reportportal.commons.BinaryDataMetaInfo;
import com.epam.ta.reportportal.entity.attachment.Attachment;
import java.util.function.Supplier;

public class AttachmentBuilder
implements Supplier<Attachment> {
    private final Attachment attachment = new Attachment();

    public AttachmentBuilder withFileId(String fileId) {
        this.attachment.setFileId(fileId);
        return this;
    }

    public AttachmentBuilder withThumbnailId(String thumbnailId) {
        this.attachment.setThumbnailId(thumbnailId);
        return this;
    }

    public AttachmentBuilder withContentType(String contentType) {
        this.attachment.setContentType(contentType);
        return this;
    }

    public AttachmentBuilder withProjectId(Long projectId) {
        this.attachment.setProjectId(projectId);
        return this;
    }

    public AttachmentBuilder withLaunchId(Long launchId) {
        this.attachment.setLaunchId(launchId);
        return this;
    }

    public AttachmentBuilder withItemId(Long itemId) {
        this.attachment.setItemId(itemId);
        return this;
    }

    public AttachmentBuilder withMetaInfo(BinaryDataMetaInfo metaInfo) {
        return this.withFileId(metaInfo.getFileId()).withThumbnailId(metaInfo.getThumbnailFileId()).withContentType(metaInfo.getContentType());
    }

    @Override
    public Attachment get() {
        return this.attachment;
    }
}

